/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.runtime.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.state.api.OperatorIdentifier;
import org.apache.flink.state.api.StateBootstrapTransformation;
import org.apache.flink.state.api.runtime.StateBootstrapTransformationWithID;
import org.apache.flink.state.api.runtime.metadata.OperatorStateSpecV2;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class SavepointMetadataV2 {
    private final long checkpointId;
    private final int maxParallelism;
    private final Collection<MasterState> masterStates;
    private final Map<OperatorID, OperatorStateSpecV2> operatorStateIndex;

    public SavepointMetadataV2(long checkpointId, int maxParallelism, Collection<MasterState> masterStates, Collection<OperatorState> initialStates) {
        Preconditions.checkArgument((maxParallelism > 0 && maxParallelism <= 32768 ? 1 : 0) != 0, (Object)("Maximum parallelism must be between 1 and 32768. Found: " + maxParallelism));
        Preconditions.checkNotNull(masterStates);
        this.checkpointId = checkpointId;
        this.maxParallelism = maxParallelism;
        this.masterStates = new ArrayList<MasterState>(masterStates);
        this.operatorStateIndex = CollectionUtil.newHashMapWithExpectedSize((int)initialStates.size());
        initialStates.forEach(existingState -> this.operatorStateIndex.put(existingState.getOperatorID(), OperatorStateSpecV2.existing(existingState)));
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public Collection<MasterState> getMasterStates() {
        return this.masterStates;
    }

    public OperatorState getOperatorState(OperatorIdentifier identifier) throws IOException {
        OperatorID operatorID = identifier.getOperatorId();
        OperatorStateSpecV2 operatorState = this.operatorStateIndex.get(operatorID);
        if (operatorState == null || operatorState.isNewStateTransformation()) {
            throw new IOException("Savepoint does not contain state with operator " + identifier.getUid().map(uid -> "uid " + uid).orElse("hash " + operatorID.toHexString()));
        }
        return operatorState.asExistingState();
    }

    public void removeOperator(OperatorIdentifier identifier) {
        this.operatorStateIndex.remove(identifier.getOperatorId());
    }

    public void addOperator(OperatorIdentifier identifier, StateBootstrapTransformation<?> transformation) {
        OperatorID id = identifier.getOperatorId();
        if (this.operatorStateIndex.containsKey(id)) {
            throw new IllegalArgumentException("The savepoint already contains " + identifier.getUid().map(uid -> "uid " + uid).orElse("hash " + id.toHexString()) + ". All uid's/hashes must be unique.");
        }
        this.operatorStateIndex.put(id, OperatorStateSpecV2.newWithTransformation(new StateBootstrapTransformationWithID(identifier, transformation)));
    }

    public List<OperatorState> getExistingOperators() {
        return this.operatorStateIndex.values().stream().filter(OperatorStateSpecV2::isExistingState).map(OperatorStateSpecV2::asExistingState).collect(Collectors.toList());
    }

    public List<StateBootstrapTransformationWithID<?>> getNewOperators() {
        return this.operatorStateIndex.values().stream().filter(OperatorStateSpecV2::isNewStateTransformation).map(OperatorStateSpecV2::asNewStateTransformation).collect(Collectors.toList());
    }
}

