/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.util;

import org.apache.flink.formats.protobuf.shaded.com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.shaded.com.google.protobuf.ProtobufInternalUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;

public class PbFormatUtils {
    public static String getFullJavaName(Descriptors.Descriptor descriptor) {
        if (null != descriptor.getContainingType()) {
            String parentJavaFullName = PbFormatUtils.getFullJavaName(descriptor.getContainingType());
            return parentJavaFullName + "." + descriptor.getName();
        }
        String outerProtoName = PbFormatUtils.getOuterProtoPrefix(descriptor.getFile());
        return outerProtoName + descriptor.getName();
    }

    public static String getFullJavaName(Descriptors.EnumDescriptor enumDescriptor) {
        if (null != enumDescriptor.getContainingType()) {
            return PbFormatUtils.getFullJavaName(enumDescriptor.getContainingType()) + "." + enumDescriptor.getName();
        }
        String outerProtoName = PbFormatUtils.getOuterProtoPrefix(enumDescriptor.getFile());
        return outerProtoName + enumDescriptor.getName();
    }

    public static boolean isSimpleType(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return true;
            }
        }
        return false;
    }

    public static String getStrongCamelCaseJsonName(String name) {
        return ProtobufInternalUtils.underScoreToCamelCase(name, true);
    }

    public static String getOuterClassName(Descriptors.FileDescriptor fileDescriptor) {
        if (fileDescriptor.getOptions().hasJavaOuterClassname()) {
            return fileDescriptor.getOptions().getJavaOuterClassname();
        }
        String[] fileNames = fileDescriptor.getName().split("/");
        String fileName = fileNames[fileNames.length - 1];
        String outerName = PbFormatUtils.getStrongCamelCaseJsonName(fileName.split("\\.")[0]);
        boolean hasSameNameMessage = fileDescriptor.getMessageTypes().stream().anyMatch(f -> f.getName().equals(outerName));
        boolean hasSameNameEnum = fileDescriptor.getEnumTypes().stream().anyMatch(f -> f.getName().equals(outerName));
        boolean hasSameNameService = fileDescriptor.getServices().stream().anyMatch(f -> f.getName().equals(outerName));
        if (hasSameNameMessage || hasSameNameEnum || hasSameNameService) {
            return outerName + "OuterClass";
        }
        return outerName;
    }

    public static String getOuterProtoPrefix(Descriptors.FileDescriptor fileDescriptor) {
        String javaPackageName;
        String string = javaPackageName = fileDescriptor.getOptions().hasJavaPackage() ? fileDescriptor.getOptions().getJavaPackage() : fileDescriptor.getPackage();
        if (fileDescriptor.getOptions().getJavaMultipleFiles()) {
            return javaPackageName + ".";
        }
        String outerClassName = PbFormatUtils.getOuterClassName(fileDescriptor);
        return javaPackageName + "." + outerClassName + ".";
    }

    public static Descriptors.Descriptor getDescriptor(String className) {
        try {
            Class<?> pbClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            return (Descriptors.Descriptor)pbClass.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("get %s descriptors error!", className), e);
        }
    }

    public static boolean isRepeatedType(LogicalType type) {
        return type instanceof MapType || type instanceof ArrayType;
    }

    public static boolean isArrayType(LogicalType type) {
        return type instanceof ArrayType;
    }
}

