/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatContext;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializer;
import org.apache.flink.formats.protobuf.util.PbCodegenAppender;
import org.apache.flink.formats.protobuf.util.PbCodegenVarId;
import org.apache.flink.formats.protobuf.util.PbFormatUtils;
import org.apache.flink.table.types.logical.LogicalType;

public class PbCodegenSimpleSerializer
implements PbCodegenSerializer {
    private final Descriptors.FieldDescriptor fd;
    private final LogicalType type;
    private final PbFormatContext formatContext;

    public PbCodegenSimpleSerializer(Descriptors.FieldDescriptor fd, LogicalType type, PbFormatContext formatContext) {
        this.fd = fd;
        this.type = type;
        this.formatContext = formatContext;
    }

    @Override
    public String codegen(String resultVar, String flinkObjectCode, int indent) throws PbCodegenException {
        PbCodegenAppender appender = new PbCodegenAppender(indent);
        switch (this.type.getTypeRoot()) {
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                appender.appendLine(resultVar + " = " + flinkObjectCode);
                return appender.code();
            }
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: {
                if (this.fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                    String enumTypeStr = PbFormatUtils.getFullJavaName(this.fd.getEnumType());
                    appender.appendLine(resultVar + " = " + enumTypeStr + ".forNumber((int)" + flinkObjectCode + ")");
                    appender.begin("if(null == " + resultVar + "){");
                    appender.appendLine(resultVar + " = " + enumTypeStr + ".values()[0]");
                    appender.end("}");
                } else {
                    appender.appendLine(resultVar + " = " + flinkObjectCode);
                }
                return appender.code();
            }
            case VARCHAR: 
            case CHAR: {
                int uid = PbCodegenVarId.getInstance().getAndIncrement();
                String fromVar = "fromVar" + uid;
                appender.appendLine("String " + fromVar);
                appender.appendLine(fromVar + " = " + flinkObjectCode + ".toString()");
                if (this.fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                    String enumValueDescVar = "enumValueDesc" + uid;
                    String enumTypeStr = PbFormatUtils.getFullJavaName(this.fd.getEnumType());
                    appender.appendLine("Descriptors.EnumValueDescriptor " + enumValueDescVar + "=" + enumTypeStr + ".getDescriptor().findValueByName(" + fromVar + ")");
                    appender.begin("if(null == " + enumValueDescVar + "){");
                    appender.appendLine(resultVar + " = " + enumTypeStr + ".values()[0]");
                    appender.end("}");
                    appender.begin("else{");
                    appender.appendLine(resultVar + " = " + enumTypeStr + ".valueOf(" + enumValueDescVar + ")");
                    appender.end("}");
                } else {
                    appender.appendLine(resultVar + " = " + fromVar);
                }
                return appender.code();
            }
            case VARBINARY: 
            case BINARY: {
                appender.appendLine(resultVar + " = ByteString.copyFrom(" + flinkObjectCode + ")");
                return appender.code();
            }
        }
        throw new PbCodegenException("Unsupported data type in schema: " + this.type);
    }
}

