/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatContext;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializer;
import org.apache.flink.formats.protobuf.util.PbCodegenAppender;
import org.apache.flink.formats.protobuf.util.PbCodegenUtils;
import org.apache.flink.formats.protobuf.util.PbCodegenVarId;
import org.apache.flink.table.types.logical.LogicalType;

public class PbCodegenArraySerializer
implements PbCodegenSerializer {
    private final Descriptors.FieldDescriptor fd;
    private final LogicalType elementType;
    private final PbFormatContext formatContext;

    public PbCodegenArraySerializer(Descriptors.FieldDescriptor fd, LogicalType elementType, PbFormatContext formatContext) {
        this.fd = fd;
        this.elementType = elementType;
        this.formatContext = formatContext;
    }

    @Override
    public String codegen(String resultVar, String flinkObjectCode, int indent) throws PbCodegenException {
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        PbCodegenAppender appender = new PbCodegenAppender(indent);
        String protoTypeStr = PbCodegenUtils.getTypeStrFromProto(this.fd, false);
        String pbListVar = "pbList" + uid;
        String flinkArrayDataVar = "arrData" + uid;
        String pbElementVar = "elementPbVar" + uid;
        String iVar = "i" + uid;
        appender.appendLine("ArrayData " + flinkArrayDataVar + " = " + flinkObjectCode);
        appender.appendLine("List<" + protoTypeStr + "> " + pbListVar + "= new ArrayList()");
        appender.begin("for(int " + iVar + "=0;" + iVar + " < " + flinkArrayDataVar + ".size(); " + iVar + "++){");
        String convertFlinkArrayElementToPbCode = PbCodegenUtils.convertFlinkArrayElementToPbWithDefaultValueCode(flinkArrayDataVar, iVar, pbElementVar, this.fd, this.elementType, this.formatContext, appender.currentIndent());
        appender.appendSegment(convertFlinkArrayElementToPbCode);
        appender.appendLine(pbListVar + ".add( " + pbElementVar + ")");
        appender.end("}");
        appender.appendLine(resultVar + " = " + pbListVar);
        return appender.code();
    }
}

