/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatConfig;
import org.apache.flink.formats.protobuf.PbFormatContext;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializeFactory;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializer;
import org.apache.flink.formats.protobuf.util.PbCodegenAppender;
import org.apache.flink.formats.protobuf.util.PbCodegenUtils;
import org.apache.flink.formats.protobuf.util.PbFormatUtils;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.types.logical.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoToRowConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoToRowConverter.class);
    private final Method parseFromMethod;
    private final Method decodeMethod;
    private boolean isCodeSplit = false;

    public ProtoToRowConverter(RowType rowType, PbFormatConfig formatConfig) throws PbCodegenException {
        try {
            Descriptors.Descriptor descriptor = PbFormatUtils.getDescriptor(formatConfig.getMessageClassName());
            Class<?> messageClass = Class.forName(formatConfig.getMessageClassName(), true, Thread.currentThread().getContextClassLoader());
            String fullMessageClassName = PbFormatUtils.getFullJavaName(descriptor);
            if (descriptor.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3) {
                formatConfig = new PbFormatConfig(formatConfig.getMessageClassName(), formatConfig.isIgnoreParseErrors(), true, formatConfig.getWriteNullStringLiterals());
            }
            PbCodegenAppender codegenAppender = new PbCodegenAppender();
            PbFormatContext pbFormatContext = new PbFormatContext(formatConfig);
            String uuid = UUID.randomUUID().toString().replaceAll("\\-", "");
            String generatedClassName = "GeneratedProtoToRow_" + uuid;
            String generatedPackageName = ProtoToRowConverter.class.getPackage().getName();
            codegenAppender.appendLine("package " + generatedPackageName);
            codegenAppender.appendLine("import " + RowData.class.getName());
            codegenAppender.appendLine("import " + ArrayData.class.getName());
            codegenAppender.appendLine("import " + BinaryStringData.class.getName());
            codegenAppender.appendLine("import " + GenericRowData.class.getName());
            codegenAppender.appendLine("import " + GenericMapData.class.getName());
            codegenAppender.appendLine("import " + GenericArrayData.class.getName());
            codegenAppender.appendLine("import " + ArrayList.class.getName());
            codegenAppender.appendLine("import " + List.class.getName());
            codegenAppender.appendLine("import " + Map.class.getName());
            codegenAppender.appendLine("import " + HashMap.class.getName());
            codegenAppender.appendLine("import " + ByteString.class.getName());
            codegenAppender.appendSegment("public class " + generatedClassName + "{");
            codegenAppender.appendSegment("public static RowData decode(" + fullMessageClassName + " message){");
            codegenAppender.appendLine("RowData rowData=null");
            PbCodegenDeserializer codegenDes = PbCodegenDeserializeFactory.getPbCodegenTopRowDes(descriptor, rowType, pbFormatContext);
            String genCode = codegenDes.codegen("rowData", "message", 0);
            codegenAppender.appendSegment(genCode);
            codegenAppender.appendLine("return rowData");
            codegenAppender.appendSegment("}");
            if (!pbFormatContext.getSplitMethodStack().isEmpty()) {
                this.isCodeSplit = true;
                for (String splitMethod : pbFormatContext.getSplitMethodStack()) {
                    codegenAppender.appendSegment(splitMethod);
                }
            }
            codegenAppender.appendSegment("}");
            String printCode = codegenAppender.printWithLineNumber();
            LOG.debug("Protobuf decode codegen: \n" + printCode);
            Class generatedClass = PbCodegenUtils.compileClass(Thread.currentThread().getContextClassLoader(), generatedPackageName + "." + generatedClassName, codegenAppender.code());
            this.decodeMethod = generatedClass.getMethod("decode", messageClass);
            this.parseFromMethod = messageClass.getMethod("parseFrom", byte[].class);
        }
        catch (Exception ex) {
            throw new PbCodegenException(ex);
        }
    }

    public RowData convertProtoBinaryToRow(byte[] data) throws Exception {
        Object messageObj = this.parseFromMethod.invoke(null, new Object[]{data});
        return (RowData)this.decodeMethod.invoke(null, messageObj);
    }

    @VisibleForTesting
    protected boolean isCodeSplit() {
        return this.isCodeSplit;
    }
}

