/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterModel;

public class SqlAlterModelSet
extends SqlAlterModel {
    private final SqlNodeList modelOptionList;

    public SqlAlterModelSet(SqlParserPos pos, SqlIdentifier modelName, boolean ifModelExists, SqlNodeList modelOptionList) {
        super(pos, modelName, ifModelExists);
        this.modelOptionList = Objects.requireNonNull(modelOptionList, "modelOptionList should not be null");
    }

    public SqlNodeList getOptionList() {
        return this.modelOptionList;
    }

    public List<SqlNode> getOperandList() {
        return List.of(this.modelName, this.modelOptionList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("SET");
        SqlWriter.Frame withFrame = writer.startList("(", ")");
        for (SqlNode modelOption : this.modelOptionList) {
            SqlUnparseUtils.printIndent(writer);
            modelOption.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(withFrame);
    }
}

