/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;

public class SqlAlterTableRename
extends SqlAlterTable {
    private final SqlIdentifier newTableIdentifier;

    public SqlAlterTableRename(SqlParserPos pos, SqlIdentifier tableName, SqlIdentifier newTableName, boolean ifTableExists) {
        super(pos, tableName, ifTableExists);
        this.newTableIdentifier = Objects.requireNonNull(newTableName, "new tableName should not be null");
    }

    public SqlAlterTableRename(SqlParserPos pos, SqlIdentifier tableName, SqlIdentifier newTableName) {
        this(pos, tableName, newTableName, false);
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.tableIdentifier, (Object)this.newTableIdentifier);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("RENAME TO");
        this.newTableIdentifier.unparse(writer, leftPrec, rightPrec);
    }

    public String[] fullNewTableName() {
        return (String[])this.newTableIdentifier.names.toArray((Object[])new String[0]);
    }
}

