/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlShowFunctions
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SHOW FUNCTIONS", SqlKind.OTHER);
    private final boolean requireUser;
    private final String preposition;
    private final SqlIdentifier databaseName;
    private final String likeType;
    private final SqlCharStringLiteral likeLiteral;
    private final boolean notLike;

    public SqlShowFunctions(SqlParserPos pos, boolean requireUser, String preposition, SqlIdentifier databaseName, String likeType, SqlCharStringLiteral likeLiteral, boolean notLike) {
        super(pos);
        this.requireUser = requireUser;
        this.preposition = preposition;
        SqlIdentifier sqlIdentifier = this.databaseName = preposition != null ? Objects.requireNonNull(databaseName, "Database name must not be null.") : null;
        if (likeType != null) {
            this.likeType = likeType;
            this.likeLiteral = Objects.requireNonNull(likeLiteral, "Like pattern must not be null");
            this.notLike = notLike;
        } else {
            this.likeType = null;
            this.likeLiteral = null;
            this.notLike = false;
        }
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return Objects.isNull(this.databaseName) ? Collections.emptyList() : Collections.singletonList(this.databaseName);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        String keyword = this.requireUser ? "SHOW USER FUNCTIONS" : "SHOW FUNCTIONS";
        if (this.preposition == null) {
            writer.keyword(keyword);
        } else if (this.databaseName != null) {
            writer.keyword(keyword + " " + this.preposition);
            this.databaseName.unparse(writer, leftPrec, rightPrec);
        }
        if (this.isWithLike()) {
            if (this.isNotLike()) {
                writer.keyword(String.format("NOT %s '%s'", this.likeType, this.getLikeSqlPattern()));
            } else {
                writer.keyword(String.format("%s '%s'", this.likeType, this.getLikeSqlPattern()));
            }
        }
    }

    public boolean requireUser() {
        return this.requireUser;
    }

    public String getPreposition() {
        return this.preposition;
    }

    public String[] fullDatabaseName() {
        return Objects.isNull(this.databaseName) ? new String[]{} : (String[])this.databaseName.names.toArray((Object[])new String[0]);
    }

    public boolean isWithLike() {
        return this.likeType != null;
    }

    public String getLikeType() {
        return this.likeType;
    }

    public String getLikeSqlPattern() {
        return Objects.isNull(this.likeLiteral) ? null : (String)this.likeLiteral.getValueAs(String.class);
    }

    public boolean isNotLike() {
        return this.notLike;
    }
}

