/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlShowTables
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SHOW TABLES", SqlKind.OTHER);
    protected final SqlIdentifier databaseName;
    protected final String preposition;
    protected final boolean notLike;
    protected final SqlCharStringLiteral likeLiteral;

    public SqlShowTables(SqlParserPos pos) {
        super(pos);
        this.preposition = null;
        this.databaseName = null;
        this.notLike = false;
        this.likeLiteral = null;
    }

    public SqlShowTables(SqlParserPos pos, String preposition, SqlIdentifier databaseName, boolean notLike, SqlCharStringLiteral likeLiteral) {
        super(pos);
        this.preposition = preposition;
        this.databaseName = preposition != null ? Objects.requireNonNull(databaseName, "Database name must not be null.") : null;
        this.notLike = notLike;
        this.likeLiteral = likeLiteral;
    }

    public String getLikeSqlPattern() {
        return Objects.isNull(this.likeLiteral) ? null : (String)this.likeLiteral.getValueAs(String.class);
    }

    public boolean isNotLike() {
        return this.notLike;
    }

    public SqlCharStringLiteral getLikeLiteral() {
        return this.likeLiteral;
    }

    public boolean isWithLike() {
        return Objects.nonNull(this.likeLiteral);
    }

    public String getPreposition() {
        return this.preposition;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return Objects.isNull(this.databaseName) ? Collections.emptyList() : Collections.singletonList(this.databaseName);
    }

    public String[] fullDatabaseName() {
        return Objects.isNull(this.databaseName) ? new String[]{} : (String[])this.databaseName.names.toArray((Object[])new String[0]);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.preposition == null) {
            writer.keyword("SHOW TABLES");
        } else if (this.databaseName != null) {
            writer.keyword("SHOW TABLES " + this.preposition);
            this.databaseName.unparse(writer, leftPrec, rightPrec);
        }
        if (this.isWithLike()) {
            if (this.isNotLike()) {
                writer.keyword(String.format("NOT LIKE '%s'", this.getLikeSqlPattern()));
            } else {
                writer.keyword(String.format("LIKE '%s'", this.getLikeSqlPattern()));
            }
        }
    }
}

