/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.vector.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.apache.flink.formats.parquet.vector.reader.AbstractColumnReader;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.columnar.vector.writable.WritableIntVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableTimestampVector;
import org.apache.flink.util.Preconditions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

public class TimestampColumnReader
extends AbstractColumnReader<WritableTimestampVector> {
    public static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;
    public static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    public static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    public static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    public static final long MICROS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toMicros(1L);
    public static final long NANOS_PER_MICROSECONDS = TimeUnit.MICROSECONDS.toNanos(1L);
    public static final long MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    public static final long MICROS_PER_SECOND = TimeUnit.SECONDS.toMicros(1L);
    private final boolean utcTimestamp;
    private final PrimitiveType.PrimitiveTypeName actualName;
    private final LogicalTypeAnnotation.TimeUnit timeUnit;

    public TimestampColumnReader(boolean utcTimestamp, ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        super(descriptor, pageReader);
        this.utcTimestamp = utcTimestamp;
        this.actualName = descriptor.getPrimitiveType().getPrimitiveTypeName();
        this.checkTypeName();
        this.timeUnit = this.actualName == PrimitiveType.PrimitiveTypeName.INT64 ? ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)descriptor.getPrimitiveType().getLogicalTypeAnnotation()).getUnit() : null;
    }

    private void checkTypeName() {
        Preconditions.checkArgument((this.actualName == PrimitiveType.PrimitiveTypeName.INT96 || this.actualName == PrimitiveType.PrimitiveTypeName.INT64 ? 1 : 0) != 0, (String)"Expected type name: %s or %s, actual type name: %s", (Object[])new Object[]{PrimitiveType.PrimitiveTypeName.INT64, this.actualName == PrimitiveType.PrimitiveTypeName.INT96, this.actualName});
    }

    @Override
    protected boolean supportLazyDecode() {
        return this.utcTimestamp;
    }

    @Override
    protected void readBatch(int rowId, int num, WritableTimestampVector column) {
        for (int i = 0; i < num; ++i) {
            if (this.runLenDecoder.readInteger() == this.maxDefLevel) {
                ByteBuffer buffer;
                if (this.actualName == PrimitiveType.PrimitiveTypeName.INT64) {
                    buffer = this.readDataBuffer(8);
                    column.setTimestamp(rowId + i, TimestampColumnReader.int64ToTimestamp(this.utcTimestamp, buffer.getLong(), this.timeUnit));
                    continue;
                }
                buffer = this.readDataBuffer(12);
                column.setTimestamp(rowId + i, TimestampColumnReader.int96ToTimestamp(this.utcTimestamp, buffer.getLong(), buffer.getInt()));
                continue;
            }
            column.setNullAt(rowId + i);
        }
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, WritableTimestampVector column, WritableIntVector dictionaryIds) {
        for (int i = rowId; i < rowId + num; ++i) {
            if (column.isNullAt(i)) continue;
            if (this.actualName == PrimitiveType.PrimitiveTypeName.INT64) {
                column.setTimestamp(i, TimestampColumnReader.decodeInt64ToTimestamp(this.utcTimestamp, this.dictionary, dictionaryIds.getInt(i), this.timeUnit));
                continue;
            }
            column.setTimestamp(i, TimestampColumnReader.decodeInt96ToTimestamp(this.utcTimestamp, this.dictionary, dictionaryIds.getInt(i)));
        }
    }

    public static TimestampData decodeInt64ToTimestamp(boolean utcTimestamp, Dictionary dictionary, int id, LogicalTypeAnnotation.TimeUnit timeUnit) {
        return TimestampColumnReader.int64ToTimestamp(utcTimestamp, dictionary.decodeToLong(id), timeUnit);
    }

    public static TimestampData decodeInt96ToTimestamp(boolean utcTimestamp, Dictionary dictionary, int id) {
        Binary binary = dictionary.decodeToBinary(id);
        Preconditions.checkArgument((binary.length() == 12 ? 1 : 0) != 0, (Object)"Timestamp with int96 should be 12 bytes.");
        ByteBuffer buffer = binary.toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        return TimestampColumnReader.int96ToTimestamp(utcTimestamp, buffer.getLong(), buffer.getInt());
    }

    public static TimestampData int96ToTimestamp(boolean utcTimestamp, long nanosOfDay, int julianDay) {
        long millisecond = TimestampColumnReader.julianDayToMillis(julianDay) + nanosOfDay / NANOS_PER_MILLISECOND;
        if (utcTimestamp) {
            int nanoOfMillisecond = (int)(nanosOfDay % NANOS_PER_MILLISECOND);
            return TimestampData.fromEpochMillis((long)millisecond, (int)nanoOfMillisecond);
        }
        Timestamp timestamp = new Timestamp(millisecond);
        timestamp.setNanos((int)(nanosOfDay % NANOS_PER_SECOND));
        return TimestampData.fromTimestamp((Timestamp)timestamp);
    }

    public static TimestampData int64ToTimestamp(boolean utcTimestamp, long value, LogicalTypeAnnotation.TimeUnit timeUnit) {
        long nanosOfMillisecond;
        long milliseconds;
        switch (timeUnit) {
            case MILLIS: {
                milliseconds = value;
                nanosOfMillisecond = value % MILLIS_PER_SECOND * NANOS_PER_MILLISECOND;
                break;
            }
            case MICROS: {
                milliseconds = value / MICROS_PER_MILLISECOND;
                nanosOfMillisecond = value % MICROS_PER_SECOND * NANOS_PER_MICROSECONDS;
                break;
            }
            case NANOS: {
                milliseconds = value / NANOS_PER_MILLISECOND;
                nanosOfMillisecond = value % NANOS_PER_SECOND;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid time unit: " + timeUnit);
            }
        }
        if (utcTimestamp) {
            return TimestampData.fromEpochMillis((long)milliseconds, (int)((int)(nanosOfMillisecond % NANOS_PER_MILLISECOND)));
        }
        Timestamp timestamp = new Timestamp(milliseconds);
        timestamp.setNanos((int)nanosOfMillisecond);
        return TimestampData.fromTimestamp((Timestamp)timestamp);
    }

    private static long julianDayToMillis(int julianDay) {
        return (long)(julianDay - 2440588) * MILLIS_IN_DAY;
    }
}

