/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.vector;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.time.LocalDate;
import org.apache.flink.orc.TimestampUtil;
import org.apache.flink.orc.vector.OrcArrayColumnVector;
import org.apache.flink.orc.vector.OrcBytesColumnVector;
import org.apache.flink.orc.vector.OrcDecimalColumnVector;
import org.apache.flink.orc.vector.OrcDoubleColumnVector;
import org.apache.flink.orc.vector.OrcLegacyTimestampColumnVector;
import org.apache.flink.orc.vector.OrcLongColumnVector;
import org.apache.flink.orc.vector.OrcMapColumnVector;
import org.apache.flink.orc.vector.OrcRowColumnVector;
import org.apache.flink.orc.vector.OrcTimestampColumnVector;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;

public abstract class AbstractOrcColumnVector
implements org.apache.flink.table.data.columnar.vector.ColumnVector {
    private ColumnVector vector;

    AbstractOrcColumnVector(ColumnVector vector) {
        this.vector = vector;
    }

    public boolean isNullAt(int i) {
        return !this.vector.noNulls && this.vector.isNull[this.vector.isRepeating ? 0 : i];
    }

    public static org.apache.flink.table.data.columnar.vector.ColumnVector createFlinkVector(ColumnVector vector, LogicalType logicalType) {
        if (vector instanceof LongColumnVector) {
            if (logicalType.getTypeRoot() == LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) {
                return new OrcLegacyTimestampColumnVector((LongColumnVector)vector);
            }
            return new OrcLongColumnVector((LongColumnVector)vector);
        }
        if (vector instanceof DoubleColumnVector) {
            return new OrcDoubleColumnVector((DoubleColumnVector)vector);
        }
        if (vector instanceof BytesColumnVector) {
            return new OrcBytesColumnVector((BytesColumnVector)vector);
        }
        if (vector instanceof DecimalColumnVector) {
            return new OrcDecimalColumnVector((DecimalColumnVector)vector);
        }
        if (TimestampUtil.isHiveTimestampColumnVector(vector)) {
            return new OrcTimestampColumnVector(vector);
        }
        if (vector instanceof ListColumnVector) {
            return new OrcArrayColumnVector((ListColumnVector)vector, (ArrayType)logicalType);
        }
        if (vector instanceof StructColumnVector) {
            return new OrcRowColumnVector((StructColumnVector)vector, (RowType)logicalType);
        }
        if (vector instanceof MapColumnVector) {
            return new OrcMapColumnVector((MapColumnVector)vector, (MapType)logicalType);
        }
        throw new UnsupportedOperationException("Unsupported vector: " + vector.getClass().getName());
    }

    public static org.apache.flink.table.data.columnar.vector.ColumnVector createFlinkVectorFromConstant(LogicalType type, Object value, int batchSize) {
        return AbstractOrcColumnVector.createFlinkVector(AbstractOrcColumnVector.createHiveVectorFromConstant(type, value, batchSize), type);
    }

    private static ColumnVector createHiveVectorFromConstant(LogicalType type, Object value, int batchSize) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return AbstractOrcColumnVector.createBytesVector(batchSize, value);
            }
            case BOOLEAN: {
                return AbstractOrcColumnVector.createLongVector(batchSize, (Boolean)value != false ? 1 : 0);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return AbstractOrcColumnVector.createLongVector(batchSize, value);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                return AbstractOrcColumnVector.createDecimalVector(batchSize, decimalType.getPrecision(), decimalType.getScale(), value);
            }
            case FLOAT: 
            case DOUBLE: {
                return AbstractOrcColumnVector.createDoubleVector(batchSize, value);
            }
            case DATE: {
                if (value instanceof LocalDate) {
                    value = Date.valueOf((LocalDate)value);
                }
                return AbstractOrcColumnVector.createLongVector(batchSize, DateTimeUtils.toInternal((Date)((Date)value)));
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return TimestampUtil.createVectorFromConstant(batchSize, value);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
    }

    private static LongColumnVector createLongVector(int batchSize, Object value) {
        LongColumnVector lcv = new LongColumnVector(batchSize);
        if (value == null) {
            lcv.noNulls = false;
            lcv.isNull[0] = true;
            lcv.isRepeating = true;
        } else {
            lcv.fill(((Number)value).longValue());
            lcv.isNull[0] = false;
        }
        return lcv;
    }

    private static BytesColumnVector createBytesVector(int batchSize, Object value) {
        BytesColumnVector bcv = new BytesColumnVector(batchSize);
        if (value == null) {
            bcv.noNulls = false;
            bcv.isNull[0] = true;
            bcv.isRepeating = true;
        } else {
            byte[] bytes = value instanceof byte[] ? (byte[])value : value.toString().getBytes(StandardCharsets.UTF_8);
            bcv.initBuffer(bytes.length);
            bcv.fill(bytes);
            bcv.isNull[0] = false;
        }
        return bcv;
    }

    private static DecimalColumnVector createDecimalVector(int batchSize, int precision, int scale, Object value) {
        DecimalColumnVector dv = new DecimalColumnVector(batchSize, precision, scale);
        if (value == null) {
            dv.noNulls = false;
            dv.isNull[0] = true;
            dv.isRepeating = true;
        } else {
            dv.set(0, value instanceof HiveDecimal ? (HiveDecimal)value : HiveDecimal.create((BigDecimal)value));
            dv.isRepeating = true;
            dv.isNull[0] = false;
        }
        return dv;
    }

    private static DoubleColumnVector createDoubleVector(int batchSize, Object value) {
        DoubleColumnVector dcv = new DoubleColumnVector(batchSize);
        if (value == null) {
            dcv.noNulls = false;
            dcv.isNull[0] = true;
            dcv.isRepeating = true;
        } else {
            dcv.fill(((Number)value).doubleValue());
            dcv.isNull[0] = false;
        }
        return dcv;
    }
}

