/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.shim;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.orc.shim.OrcShimV200;
import org.apache.flink.orc.shim.OrcShimV210;
import org.apache.flink.orc.shim.OrcShimV230;
import org.apache.flink.orc.vector.OrcVectorizedBatchWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;

public interface OrcShim<BATCH>
extends Serializable {
    public RecordReader createRecordReader(Configuration var1, TypeDescription var2, int[] var3, List<OrcFilters.Predicate> var4, Path var5, long var6, long var8) throws IOException;

    public OrcVectorizedBatchWrapper<BATCH> createBatchWrapper(TypeDescription var1, int var2);

    public boolean nextBatch(RecordReader var1, BATCH var2) throws IOException;

    public static OrcShim<VectorizedRowBatch> defaultShim() {
        return new OrcShimV230();
    }

    public static OrcShim<VectorizedRowBatch> createShim(String hiveVersion) {
        if (hiveVersion.startsWith("2.0")) {
            return new OrcShimV200();
        }
        if (hiveVersion.startsWith("2.1")) {
            return new OrcShimV210();
        }
        if (hiveVersion.startsWith("2.2") || hiveVersion.startsWith("2.3") || hiveVersion.startsWith("3.")) {
            return new OrcShimV230();
        }
        throw new UnsupportedOperationException("Unsupported hive version for orc shim: " + hiveVersion);
    }
}

