/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.table.jdbc.utils.DriverUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DriverInfo {
    private static final Logger LOG = LoggerFactory.getLogger(DriverInfo.class);
    private static final String DRIVER_NAME_OPTION = "flink.driver.name";
    private static final String DRIVER_VERSION_OPTION = "flink.driver.version";
    static final String DRIVER_NAME;
    static final String DRIVER_VERSION;
    static final int DRIVER_VERSION_MAJOR;
    static final int DRIVER_VERSION_MINOR;

    private DriverInfo() {
    }

    static {
        try {
            Properties properties = new Properties();
            URL url = DriverInfo.class.getResource("driver.properties");
            try (InputStream in = DriverUtils.checkNotNull(url, "Cannot find driver.properties").openStream();){
                properties.load(in);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            DRIVER_NAME = DriverUtils.checkNotNull(properties.getProperty(DRIVER_NAME_OPTION), String.format("%s is null or empty", DRIVER_NAME_OPTION));
            DRIVER_VERSION = DriverUtils.checkNotNull(properties.getProperty(DRIVER_VERSION_OPTION), String.format("%s is null or empty", DRIVER_VERSION_OPTION));
            Matcher matcher = Pattern.compile("^(\\d+)(\\.(\\d+))($|[.-])?").matcher(DRIVER_VERSION);
            DriverUtils.checkArgument(matcher.find(), String.format("%s is invalid: %s", DRIVER_VERSION_OPTION, DRIVER_VERSION));
            DRIVER_VERSION_MAJOR = Integer.parseInt(matcher.group(1));
            String minor = matcher.group(3);
            DRIVER_VERSION_MINOR = Integer.parseInt(DriverUtils.isNullOrWhitespaceOnly(minor) ? "0" : minor);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to load flink driver info", (Throwable)e);
            throw e;
        }
    }
}

