/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import javax.annotation.Nonnull;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class WrappingRuntimeException
extends FlinkRuntimeException {
    private static final long serialVersionUID = 1L;

    public WrappingRuntimeException(@Nonnull Throwable cause) {
        super(Preconditions.checkNotNull(cause));
    }

    public WrappingRuntimeException(String message, @Nonnull Throwable cause) {
        super(message, Preconditions.checkNotNull(cause));
    }

    public Throwable unwrap() {
        Throwable cause = this.getCause();
        return cause instanceof WrappingRuntimeException ? ((WrappingRuntimeException)cause).unwrap() : cause;
    }

    public static RuntimeException wrapIfNecessary(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new WrappingRuntimeException(throwable);
    }
}

