/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SerializedListAccumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.configuration.Configuration;

@Internal
public final class Utils {
    public static final Random RNG = new Random();

    public static String getCallLocationName() {
        return Utils.getCallLocationName(4);
    }

    public static String getCallLocationName(int depth) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length <= depth) {
            return "<unknown>";
        }
        StackTraceElement elem = stackTrace[depth];
        return String.format("%s(%s:%d)", elem.getMethodName(), elem.getFileName(), elem.getLineNumber());
    }

    public static <T> String getSerializerTree(TypeInformation<T> ti) {
        return Utils.getSerializerTree(ti, 0);
    }

    private static <T> String getSerializerTree(TypeInformation<T> ti, int indent) {
        Object ret = "";
        if (ti instanceof CompositeType) {
            ret = (String)ret + StringUtils.repeat((char)' ', (int)indent) + ti.getClass().getSimpleName() + "\n";
            CompositeType cti = (CompositeType)ti;
            String[] fieldNames = cti.getFieldNames();
            for (int i = 0; i < cti.getArity(); ++i) {
                TypeInformation fieldType = cti.getTypeAt(i);
                ret = (String)ret + StringUtils.repeat((char)' ', (int)(indent + 2)) + fieldNames[i] + ":" + Utils.getSerializerTree(fieldType, indent);
            }
        } else if (ti instanceof GenericTypeInfo) {
            ret = (String)ret + StringUtils.repeat((char)' ', (int)indent) + "GenericTypeInfo (" + ti.getTypeClass().getSimpleName() + ")\n";
            ret = (String)ret + Utils.getGenericTypeTree(ti.getTypeClass(), indent + 4);
        } else {
            ret = (String)ret + StringUtils.repeat((char)' ', (int)indent) + ti.toString() + "\n";
        }
        return ret;
    }

    private static String getGenericTypeTree(Class<?> type, int indent) {
        Object ret = "";
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            ret = (String)ret + StringUtils.repeat((char)' ', (int)indent) + field.getName() + ":" + field.getType().getName() + (field.getType().isEnum() ? " (is enum)" : "") + "\n";
            if (field.getType().isPrimitive()) continue;
            ret = (String)ret + Utils.getGenericTypeTree(field.getType(), indent + 4);
        }
        return ret;
    }

    public static <T> Optional<T> resolveFactory(ThreadLocal<T> threadLocalFactory, @Nullable T staticFactory) {
        T localFactory = threadLocalFactory.get();
        T factory = localFactory == null ? staticFactory : localFactory;
        return Optional.ofNullable(factory);
    }

    public static String getKeyFromArgs(String[] args, int index) {
        String key;
        if (args[index].startsWith("--")) {
            key = args[index].substring(2);
        } else if (args[index].startsWith("-")) {
            key = args[index].substring(1);
        } else {
            throw new IllegalArgumentException(String.format("Error parsing arguments '%s' on '%s'. Please prefix keys with -- or -.", Arrays.toString(args), args[index]));
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("The input " + Arrays.toString(args) + " contains an empty argument");
        }
        return key;
    }

    private Utils() {
        throw new RuntimeException();
    }

    public static class ChecksumHashCodeHelper<T>
    extends RichOutputFormat<T> {
        private static final long serialVersionUID = 1L;
        private final String id;
        private long counter;
        private long checksum;

        public ChecksumHashCodeHelper(String id) {
            this.id = id;
            this.counter = 0L;
            this.checksum = 0L;
        }

        @Override
        public void configure(Configuration parameters) {
        }

        @Override
        public void open(OutputFormat.InitializationContext context) {
        }

        @Override
        public void writeRecord(T record) throws IOException {
            ++this.counter;
            this.checksum += (long)record.hashCode() & 0xFFFFFFFFL;
        }

        @Override
        public void close() throws IOException {
            ChecksumHashCode update = new ChecksumHashCode(this.counter, this.checksum);
            this.getRuntimeContext().addAccumulator(this.id, update);
        }
    }

    public static class ChecksumHashCode
    implements SimpleAccumulator<ChecksumHashCode> {
        private static final long serialVersionUID = 1L;
        private long count;
        private long checksum;

        public ChecksumHashCode() {
        }

        public ChecksumHashCode(long count, long checksum) {
            this.count = count;
            this.checksum = checksum;
        }

        public long getCount() {
            return this.count;
        }

        public long getChecksum() {
            return this.checksum;
        }

        @Override
        public void add(ChecksumHashCode value) {
            this.count += value.count;
            this.checksum += value.checksum;
        }

        @Override
        public ChecksumHashCode getLocalValue() {
            return this;
        }

        @Override
        public void resetLocal() {
            this.count = 0L;
            this.checksum = 0L;
        }

        @Override
        public void merge(Accumulator<ChecksumHashCode, ChecksumHashCode> other) {
            this.add(other.getLocalValue());
        }

        public ChecksumHashCode clone() {
            return new ChecksumHashCode(this.count, this.checksum);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ChecksumHashCode) {
                ChecksumHashCode other = (ChecksumHashCode)obj;
                return this.count == other.count && this.checksum == other.checksum;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.count + this.checksum);
        }

        public String toString() {
            return String.format("ChecksumHashCode 0x%016x, count %d", this.checksum, this.count);
        }
    }

    public static class CollectHelper<T>
    extends RichOutputFormat<T> {
        private static final long serialVersionUID = 1L;
        private final String id;
        private final TypeSerializer<T> serializer;
        private SerializedListAccumulator<T> accumulator;

        public CollectHelper(String id, TypeSerializer<T> serializer) {
            this.id = id;
            this.serializer = serializer;
        }

        @Override
        public void configure(Configuration parameters) {
        }

        @Override
        public void open(OutputFormat.InitializationContext context) {
            this.accumulator = new SerializedListAccumulator();
        }

        @Override
        public void writeRecord(T record) throws IOException {
            this.accumulator.add(record, this.serializer);
        }

        @Override
        public void close() {
            if (this.accumulator != null) {
                this.getRuntimeContext().addAccumulator(this.id, this.accumulator);
            }
        }
    }

    public static class CountHelper<T>
    extends RichOutputFormat<T> {
        private static final long serialVersionUID = 1L;
        private final String id;
        private long counter;

        public CountHelper(String id) {
            this.id = id;
            this.counter = 0L;
        }

        @Override
        public void configure(Configuration parameters) {
        }

        @Override
        public void open(OutputFormat.InitializationContext context) {
        }

        @Override
        public void writeRecord(T record) {
            ++this.counter;
        }

        @Override
        public void close() {
            this.getRuntimeContext().getLongCounter(this.id).add(this.counter);
        }
    }
}

