/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Objects;
import org.apache.flink.annotation.Internal;

@Internal
public class TaggedUnion<T1, T2> {
    private final T1 one;
    private final T2 two;

    private TaggedUnion(T1 one, T2 two) {
        this.one = one;
        this.two = two;
    }

    public boolean isOne() {
        return this.one != null;
    }

    public boolean isTwo() {
        return this.two != null;
    }

    public T1 getOne() {
        return this.one;
    }

    public T2 getTwo() {
        return this.two;
    }

    public static <T1, T2> TaggedUnion<T1, T2> one(T1 one) {
        return new TaggedUnion<T1, Object>(one, null);
    }

    public static <T1, T2> TaggedUnion<T1, T2> two(T2 two) {
        return new TaggedUnion<Object, T2>(null, two);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaggedUnion)) {
            return false;
        }
        TaggedUnion other = (TaggedUnion)obj;
        return Objects.equals(this.one, other.one) && Objects.equals(this.two, other.two);
    }
}

