/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.CheckedSupplier;

public class OptionalFailure<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private transient T value;
    @Nullable
    private Throwable failureCause;

    private OptionalFailure(@Nullable T value, @Nullable Throwable failureCause) {
        this.value = value;
        this.failureCause = failureCause;
    }

    public static <T> OptionalFailure<T> of(T value) {
        return new OptionalFailure<T>(value, null);
    }

    public static <T> OptionalFailure<T> ofFailure(Throwable failureCause) {
        return new OptionalFailure<Object>(null, failureCause);
    }

    public static <T> OptionalFailure<T> createFrom(CheckedSupplier<T> valueSupplier) {
        try {
            return OptionalFailure.of(valueSupplier.get());
        }
        catch (Exception ex) {
            return OptionalFailure.ofFailure(ex);
        }
    }

    public T get() throws FlinkException {
        if (this.value != null) {
            return this.value;
        }
        Preconditions.checkNotNull(this.failureCause);
        throw new FlinkException(this.failureCause);
    }

    public T getUnchecked() throws FlinkRuntimeException {
        if (this.value != null) {
            return this.value;
        }
        Preconditions.checkNotNull(this.failureCause);
        throw new FlinkRuntimeException(this.failureCause);
    }

    public Throwable getFailureCause() {
        return Preconditions.checkNotNull(this.failureCause);
    }

    public boolean isFailure() {
        return this.failureCause != null;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.failureCause);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OptionalFailure)) {
            return false;
        }
        OptionalFailure other = (OptionalFailure)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.failureCause, other.failureCause);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.value);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.value = stream.readObject();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{value=" + String.valueOf(this.value) + ", failureCause=" + String.valueOf(this.failureCause) + "}";
    }
}

