/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;

@Internal
class TemporalOverlapsInputTypeStrategy
implements InputTypeStrategy {
    TemporalOverlapsInputTypeStrategy() {
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return ConstantArgumentCount.of(4);
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> args = callContext.getArgumentDataTypes();
        LogicalType leftTimePoint = args.get(0).getLogicalType();
        LogicalType leftTemporal = args.get(1).getLogicalType();
        LogicalType rightTimePoint = args.get(2).getLogicalType();
        LogicalType rightTemporal = args.get(3).getLogicalType();
        if (!leftTimePoint.is(LogicalTypeFamily.DATETIME)) {
            return callContext.fail(throwOnFailure, "TEMPORAL_OVERLAPS requires 1st argument 'leftTimePoint' to be a DATETIME type, but is %s", leftTimePoint);
        }
        if (!rightTimePoint.is(LogicalTypeFamily.DATETIME)) {
            return callContext.fail(throwOnFailure, "TEMPORAL_OVERLAPS requires 3rd argument 'rightTimePoint' to be a DATETIME type, but is %s", rightTimePoint);
        }
        if (!leftTimePoint.equals(rightTimePoint)) {
            return callContext.fail(throwOnFailure, "TEMPORAL_OVERLAPS requires 'leftTimePoint' and 'rightTimePoint' arguments to be of the same type, but is %s != %s", leftTimePoint, rightTimePoint);
        }
        if (leftTemporal.is(LogicalTypeFamily.DATETIME)) {
            if (!leftTemporal.equals(leftTimePoint)) {
                return callContext.fail(throwOnFailure, "TEMPORAL_OVERLAPS requires 'leftTemporal' and 'leftTimePoint' arguments to be of the same type if 'leftTemporal' is a DATETIME, but is %s != %s", leftTemporal, leftTimePoint);
            }
        } else if (!leftTemporal.is(LogicalTypeFamily.INTERVAL)) {
            return callContext.fail(throwOnFailure, "TEMPORAL_OVERLAPS requires 2nd argument 'leftTemporal' to be DATETIME or INTERVAL type, but is %s", leftTemporal);
        }
        if (rightTemporal.is(LogicalTypeFamily.DATETIME)) {
            if (!rightTemporal.equals(rightTimePoint)) {
                return callContext.fail(throwOnFailure, "TEMPORAL_OVERLAPS requires 'rightTemporal' and 'rightTimePoint' arguments to be of the same type if 'rightTemporal' is a DATETIME, but is %s != %s", rightTemporal, rightTimePoint);
            }
        } else if (!rightTemporal.is(LogicalTypeFamily.INTERVAL)) {
            return callContext.fail(throwOnFailure, "TEMPORAL_OVERLAPS requires 4th argument 'rightTemporal' to be DATETIME or INTERVAL type, but is %s", rightTemporal);
        }
        return Optional.of(args);
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Collections.singletonList(Signature.of(Signature.Argument.ofGroup("leftTimePoint", LogicalTypeFamily.DATETIME), Signature.Argument.ofGroup("leftTemporal", "TEMPORAL"), Signature.Argument.ofGroup("rightTimePoint", LogicalTypeFamily.DATETIME), Signature.Argument.ofGroup("rightTemporal", "TEMPORAL")));
    }
}

