/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.util.Preconditions;

@Internal
public final class ArrayComparableElementArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final StructuredType.StructuredComparison requiredComparison;

    public ArrayComparableElementArgumentTypeStrategy(StructuredType.StructuredComparison requiredComparison) {
        Preconditions.checkArgument(requiredComparison != StructuredType.StructuredComparison.NONE);
        this.requiredComparison = requiredComparison;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataType argumentType = argumentDataTypes.get(argumentPos);
        if (!argumentType.getLogicalType().is(LogicalTypeRoot.ARRAY)) {
            return callContext.fail(throwOnFailure, "The argument requires to be an ARRAY type", new Object[0]);
        }
        DataType elementDataType = ((CollectionDataType)argumentType).getElementDataType();
        LogicalType elementLogicalDataType = elementDataType.getLogicalType();
        if (!this.areComparable(elementLogicalDataType, elementLogicalDataType)) {
            return callContext.fail(throwOnFailure, "Type '%s' should support %s comparison with itself.", elementLogicalDataType, this.comparisonToString());
        }
        return Optional.of(argumentType);
    }

    private String comparisonToString() {
        return this.requiredComparison == StructuredType.StructuredComparison.EQUALS ? "'EQUALS'" : "both 'EQUALS' and 'ORDER'";
    }

    private boolean areComparable(LogicalType firstType, LogicalType secondType) {
        return this.areComparableWithNormalizedNullability(firstType.copy(true), secondType.copy(true));
    }

    private boolean areComparableWithNormalizedNullability(LogicalType firstType, LogicalType secondType) {
        if (firstType instanceof LegacyTypeInformationType || secondType instanceof LegacyTypeInformationType) {
            return true;
        }
        if (firstType.is(LogicalTypeRoot.NULL) || secondType.is(LogicalTypeRoot.NULL)) {
            return true;
        }
        if (firstType.is(LogicalTypeFamily.NUMERIC) && secondType.is(LogicalTypeFamily.NUMERIC)) {
            return true;
        }
        if (firstType.is(LogicalTypeFamily.DATETIME) && secondType.is(LogicalTypeFamily.DATETIME)) {
            return true;
        }
        if (firstType.is(LogicalTypeFamily.CHARACTER_STRING) && secondType.is(LogicalTypeFamily.CHARACTER_STRING)) {
            return true;
        }
        return firstType.is(LogicalTypeFamily.BINARY_STRING) && secondType.is(LogicalTypeFamily.BINARY_STRING);
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.ofGroup("ARRAY<COMPARABLE>");
    }
}

