/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.StatementResult;
import org.apache.flink.table.jdbc.BaseStatement;
import org.apache.flink.table.jdbc.FlinkConnection;
import org.apache.flink.table.jdbc.FlinkResultSet;

@NotThreadSafe
public class FlinkStatement
extends BaseStatement {
    private final FlinkConnection connection;
    private final Executor executor;
    private FlinkResultSet currentResults;
    private boolean hasResults;
    private boolean closed;

    public FlinkStatement(FlinkConnection connection) {
        this.connection = connection;
        this.executor = connection.getExecutor();
        this.currentResults = null;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        StatementResult result = this.executeInternal(sql);
        if (!result.isQueryResult()) {
            result.close();
            throw new SQLException(String.format("Statement[%s] is not a query.", sql));
        }
        this.currentResults = new FlinkResultSet(this, result);
        this.hasResults = true;
        return this.currentResults;
    }

    private void clearCurrentResults() throws SQLException {
        if (this.currentResults == null) {
            return;
        }
        this.currentResults.close();
        this.currentResults = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.cancel();
        this.connection.removeStatement(this);
        this.closed = true;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        this.clearCurrentResults();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("This result set is already closed");
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        StatementResult result = this.executeInternal(sql);
        if (result.isQueryResult() || result.getResultKind() == ResultKind.SUCCESS_WITH_CONTENT) {
            this.currentResults = new FlinkResultSet(this, result);
            this.hasResults = true;
            return true;
        }
        this.hasResults = false;
        return false;
    }

    private StatementResult executeInternal(String sql) throws SQLException {
        this.checkClosed();
        this.clearCurrentResults();
        return this.executor.executeStatement(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.currentResults == null) {
            throw new SQLException("No result set in the current statement.");
        }
        if (this.currentResults.isClosed()) {
            throw new SQLException("Result set has been closed");
        }
        return this.currentResults;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        if (this.currentResults != null) {
            this.cancel();
            return false;
        }
        throw new SQLFeatureNotSupportedException("Multiple open results not supported");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.hasResults) {
            throw new SQLFeatureNotSupportedException("FlinkStatement#getUpdateCount is not supported for query");
        }
        return 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }
}

