/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.config;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.shaded.guava33.com.google.common.collect.ImmutableSet;
import org.apache.flink.table.api.config.ExecutionConfigOptions;

@PublicEvolving
public class VectorSearchRuntimeConfigOptions {
    public static final ConfigOption<Boolean> ASYNC = ConfigOptions.key("async").booleanType().noDefaultValue().withDescription("Value can be 'true' or 'false' to suggest the planner choose the corresponding predict function. If the backend search function provider does not support the suggested mode, it will throw exception to notify users.");
    public static final ConfigOption<ExecutionConfigOptions.AsyncOutputMode> ASYNC_OUTPUT_MODE = ConfigOptions.key("output-mode").enumType(ExecutionConfigOptions.AsyncOutputMode.class).noDefaultValue().withDescription("Output mode for asynchronous vector search call operations which will convert to {@see AsyncDataStream.OutputMode}, ORDERED by default. If set to ALLOW_UNORDERED, will attempt to use {@see AsyncDataStream.OutputMode.UNORDERED} when it does not affect the correctness of the result, otherwise ORDERED will be still used.");
    public static final ConfigOption<Integer> ASYNC_MAX_CONCURRENT_OPERATIONS = ConfigOptions.key("max-concurrent-operations").intType().noDefaultValue().withDescription("The max number of async i/o operation that the async vector search call can trigger.");
    public static final ConfigOption<Duration> ASYNC_TIMEOUT = ConfigOptions.key("timeout").durationType().noDefaultValue().withDescription("Timeout from first invoke to final completion of asynchronous vector search call operation, may include multiple retries, and will be reset in case of failover.");
    private static final Set<ConfigOption<?>> supportedKeys = new HashSet();

    public static ImmutableSet<ConfigOption> getSupportedOptions() {
        return ImmutableSet.copyOf(supportedKeys);
    }

    static {
        supportedKeys.add(ASYNC);
        supportedKeys.add(ASYNC_OUTPUT_MODE);
        supportedKeys.add(ASYNC_MAX_CONCURRENT_OPERATIONS);
        supportedKeys.add(ASYNC_TIMEOUT);
    }
}

