/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.lineage;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.lineage.DefaultLineageEdge;
import org.apache.flink.streaming.api.lineage.DefaultLineageGraph;
import org.apache.flink.streaming.api.lineage.LineageEdge;
import org.apache.flink.streaming.api.lineage.LineageGraph;
import org.apache.flink.streaming.api.lineage.LineageVertex;
import org.apache.flink.streaming.api.lineage.SourceLineageVertex;
import org.apache.flink.streaming.api.transformations.LegacySinkTransformation;
import org.apache.flink.streaming.api.transformations.LegacySourceTransformation;
import org.apache.flink.streaming.api.transformations.SinkTransformation;
import org.apache.flink.streaming.api.transformations.SourceTransformation;

@Internal
public class LineageGraphUtils {
    public static LineageGraph convertToLineageGraph(List<Transformation<?>> transformations) {
        DefaultLineageGraph.LineageGraphBuilder builder = DefaultLineageGraph.builder();
        for (Transformation<?> transformation : transformations) {
            List<LineageEdge> edges = LineageGraphUtils.processSink(transformation, builder);
            for (LineageEdge lineageEdge : edges) {
                builder.addLineageEdge(lineageEdge);
            }
        }
        for (Transformation<?> transformation : transformations) {
            Optional<SourceLineageVertex> sourceOpt = LineageGraphUtils.processSource(transformation);
            sourceOpt.ifPresent(builder::addSourceVertex);
        }
        return builder.build();
    }

    private static List<LineageEdge> processSink(Transformation<?> transformation, DefaultLineageGraph.LineageGraphBuilder builder) {
        ArrayList<LineageEdge> lineageEdges = new ArrayList<LineageEdge>();
        LineageVertex sinkLineageVertex = null;
        if (transformation instanceof SinkTransformation) {
            sinkLineageVertex = ((SinkTransformation)transformation).getLineageVertex();
        } else if (transformation instanceof LegacySinkTransformation) {
            sinkLineageVertex = ((LegacySinkTransformation)transformation).getLineageVertex();
        }
        if (sinkLineageVertex != null) {
            List<Transformation<?>> predecessors = transformation.getTransitivePredecessors();
            boolean hasEdge = false;
            for (Transformation<?> predecessor : predecessors) {
                Optional<SourceLineageVertex> sourceOpt = LineageGraphUtils.processSource(predecessor);
                if (!sourceOpt.isPresent()) continue;
                lineageEdges.add(new DefaultLineageEdge(sourceOpt.get(), sinkLineageVertex));
                hasEdge = true;
            }
            if (!hasEdge) {
                builder.addSinkVertex(sinkLineageVertex);
            }
        } else {
            List<Transformation<?>> predecessors = transformation.getTransitivePredecessors();
            for (Transformation<?> predecessor : predecessors) {
                Optional<SourceLineageVertex> sourceOpt = LineageGraphUtils.processSource(predecessor);
                sourceOpt.ifPresent(builder::addSourceVertex);
            }
        }
        return lineageEdges;
    }

    private static Optional<SourceLineageVertex> processSource(Transformation<?> transformation) {
        if (transformation instanceof SourceTransformation) {
            if (((SourceTransformation)transformation).getLineageVertex() != null) {
                return Optional.of((SourceLineageVertex)((SourceTransformation)transformation).getLineageVertex());
            }
        } else if (transformation instanceof LegacySourceTransformation && ((LegacySourceTransformation)transformation).getLineageVertex() != null) {
            return Optional.of((SourceLineageVertex)((LegacySourceTransformation)transformation).getLineageVertex());
        }
        return Optional.empty();
    }
}

