/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.runtime.jobgraph.InputOutputFormatContainer;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.graph.util.ChainedOperatorHashInfo;
import org.apache.flink.streaming.api.graph.util.ChainedSourceInfo;
import org.apache.flink.streaming.api.graph.util.JobVertexBuildContext;
import org.apache.flink.streaming.api.graph.util.OperatorInfo;

@Internal
public class OperatorChainInfo {
    private final Integer startNodeId;
    private final Map<Integer, List<ChainedOperatorHashInfo>> chainedOperatorHashes;
    private final Map<Integer, ChainedSourceInfo> chainedSources;
    private final Map<Integer, ResourceSpec> chainedMinResources;
    private final Map<Integer, ResourceSpec> chainedPreferredResources;
    private final Map<Integer, String> chainedNames;
    private final Map<Integer, OperatorInfo> chainedOperatorInfos;
    private final List<OperatorCoordinator.Provider> coordinatorProviders;
    private final List<StreamNode> chainedNodes;
    private final List<StreamEdge> transitiveOutEdges;
    private final List<StreamEdge> transitiveInEdges;
    private InputOutputFormatContainer inputOutputFormatContainer = null;

    public OperatorChainInfo(int startNodeId) {
        this.startNodeId = startNodeId;
        this.chainedOperatorHashes = new HashMap<Integer, List<ChainedOperatorHashInfo>>();
        this.coordinatorProviders = new ArrayList<OperatorCoordinator.Provider>();
        this.chainedSources = new HashMap<Integer, ChainedSourceInfo>();
        this.chainedMinResources = new HashMap<Integer, ResourceSpec>();
        this.chainedPreferredResources = new HashMap<Integer, ResourceSpec>();
        this.chainedNames = new HashMap<Integer, String>();
        this.chainedNodes = new ArrayList<StreamNode>();
        this.transitiveOutEdges = new ArrayList<StreamEdge>();
        this.transitiveInEdges = new ArrayList<StreamEdge>();
        this.chainedOperatorInfos = new HashMap<Integer, OperatorInfo>();
    }

    public Integer getStartNodeId() {
        return this.startNodeId;
    }

    public List<ChainedOperatorHashInfo> getChainedOperatorHashes(int startNodeId) {
        return this.chainedOperatorHashes.get(startNodeId);
    }

    public void addCoordinatorProvider(OperatorCoordinator.Provider coordinator) {
        this.coordinatorProviders.add(coordinator);
    }

    public List<OperatorCoordinator.Provider> getCoordinatorProviders() {
        return this.coordinatorProviders;
    }

    public Map<Integer, ChainedSourceInfo> getChainedSources() {
        return this.chainedSources;
    }

    public OperatorID addNodeToChain(int currentNodeId, String operatorName, JobVertexBuildContext jobVertexBuildContext) {
        StreamGraph streamGraph = jobVertexBuildContext.getStreamGraph();
        StreamNode streamNode = streamGraph.getStreamNode(currentNodeId);
        this.recordChainedNode(streamNode);
        List operatorHashes = this.chainedOperatorHashes.computeIfAbsent(this.startNodeId, k -> new ArrayList());
        byte[] primaryHashBytes = jobVertexBuildContext.getHash(currentNodeId);
        for (byte[] legacyHash : jobVertexBuildContext.getLegacyHashes(currentNodeId)) {
            operatorHashes.add(new ChainedOperatorHashInfo(primaryHashBytes, legacyHash, streamNode));
        }
        streamNode.getCoordinatorProvider(operatorName, new OperatorID(primaryHashBytes)).map(this.coordinatorProviders::add);
        return new OperatorID(primaryHashBytes);
    }

    public void setTransitiveOutEdges(List<StreamEdge> transitiveOutEdges) {
        this.transitiveOutEdges.addAll(transitiveOutEdges);
    }

    public List<StreamEdge> getTransitiveOutEdges() {
        return this.transitiveOutEdges;
    }

    public void recordChainedNode(StreamNode streamNode) {
        this.chainedNodes.add(streamNode);
    }

    public OperatorChainInfo newChain(Integer startNodeId) {
        return new OperatorChainInfo(startNodeId);
    }

    public List<StreamNode> getAllChainedNodes() {
        return this.chainedNodes;
    }

    public boolean hasFormatContainer() {
        return this.inputOutputFormatContainer != null;
    }

    public InputOutputFormatContainer getOrCreateFormatContainer() {
        if (this.inputOutputFormatContainer == null) {
            this.inputOutputFormatContainer = new InputOutputFormatContainer(Thread.currentThread().getContextClassLoader());
        }
        return this.inputOutputFormatContainer;
    }

    public void addChainedSource(StreamNode sourceNode, ChainedSourceInfo chainedSourceInfo) {
        this.recordChainedNode(sourceNode);
        this.chainedSources.put(sourceNode.getId(), chainedSourceInfo);
    }

    public void addChainedMinResources(Integer sourceNodeId, ResourceSpec resourceSpec) {
        this.chainedMinResources.put(sourceNodeId, resourceSpec);
    }

    public ResourceSpec getChainedMinResources(Integer sourceNodeId) {
        return this.chainedMinResources.get(sourceNodeId);
    }

    public void addChainedPreferredResources(Integer sourceNodeId, ResourceSpec resourceSpec) {
        this.chainedPreferredResources.put(sourceNodeId, resourceSpec);
    }

    public ResourceSpec getChainedPreferredResources(Integer sourceNodeId) {
        return this.chainedPreferredResources.get(sourceNodeId);
    }

    public String getChainedName(Integer streamNodeId) {
        return this.chainedNames.get(streamNodeId);
    }

    public Map<Integer, String> getChainedNames() {
        return this.chainedNames;
    }

    public void addChainedName(Integer streamNodeId, String chainedName) {
        this.chainedNames.put(streamNodeId, chainedName);
    }

    public void addTransitiveInEdge(StreamEdge streamEdge) {
        this.transitiveInEdges.add(streamEdge);
    }

    public List<StreamEdge> getTransitiveInEdges() {
        return this.transitiveInEdges;
    }

    public OperatorInfo getOperatorInfo(Integer nodeId) {
        return this.chainedOperatorInfos.get(nodeId);
    }

    public OperatorInfo createAndGetOperatorInfo(Integer nodeId, OperatorID operatorId) {
        OperatorInfo operatorInfo = new OperatorInfo(operatorId);
        this.chainedOperatorInfos.put(nodeId, operatorInfo);
        return operatorInfo;
    }

    public Map<Integer, OperatorInfo> getOperatorInfos() {
        return Collections.unmodifiableMap(this.chainedOperatorInfos);
    }
}

