/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.runtime.util.config.memory.ManagedMemoryUtils;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.util.graph.StreamGraphUtils;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class SimpleTransformationTranslator<OUT, T extends Transformation<OUT>>
implements TransformationTranslator<OUT, T> {
    @Override
    public final Collection<Integer> translateForBatch(T transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull(context);
        Collection<Integer> transformedIds = this.translateForBatchInternal(transformation, context);
        this.configure(transformation, context);
        return transformedIds;
    }

    @Override
    public final Collection<Integer> translateForStreaming(T transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull(context);
        Collection<Integer> transformedIds = this.translateForStreamingInternal(transformation, context);
        this.configure(transformation, context);
        return transformedIds;
    }

    protected abstract Collection<Integer> translateForBatchInternal(T var1, TransformationTranslator.Context var2);

    protected abstract Collection<Integer> translateForStreamingInternal(T var1, TransformationTranslator.Context var2);

    private void configure(T transformation, TransformationTranslator.Context context) {
        StreamNode streamNode;
        StreamGraph streamGraph = context.getStreamGraph();
        int transformationId = ((Transformation)transformation).getId();
        StreamGraphUtils.configureBufferTimeout(streamGraph, transformationId, transformation, context.getDefaultBufferTimeout());
        if (((Transformation)transformation).getUid() != null) {
            streamGraph.setTransformationUID(transformationId, ((Transformation)transformation).getUid());
        }
        if (((Transformation)transformation).getAdditionalMetricVariables() != null) {
            streamGraph.setAdditionalMetricVariables(((Transformation)transformation).getId(), ((Transformation)transformation).getAdditionalMetricVariables());
        }
        if (((Transformation)transformation).getUserProvidedNodeHash() != null) {
            streamGraph.setTransformationUserHash(transformationId, ((Transformation)transformation).getUserProvidedNodeHash());
        }
        StreamGraphUtils.validateTransformationUid(streamGraph, transformation);
        if (((Transformation)transformation).getMinResources() != null && ((Transformation)transformation).getPreferredResources() != null) {
            streamGraph.setResources(transformationId, ((Transformation)transformation).getMinResources(), ((Transformation)transformation).getPreferredResources());
        }
        if ((streamNode = streamGraph.getStreamNode(transformationId)) != null) {
            ManagedMemoryUtils.validateUseCaseWeightsNotConflict(streamNode.getManagedMemoryOperatorScopeUseCaseWeights(), ((Transformation)transformation).getManagedMemoryOperatorScopeUseCaseWeights());
            streamNode.setManagedMemoryUseCaseWeights(((Transformation)transformation).getManagedMemoryOperatorScopeUseCaseWeights(), ((Transformation)transformation).getManagedMemorySlotScopeUseCases());
            if (null != ((Transformation)transformation).getDescription()) {
                streamNode.setOperatorDescription(((Transformation)transformation).getDescription());
            }
        }
    }
}

