/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.smile.async;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.Base64Variant;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParseException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.io.IOContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.json.JsonReadContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.smile.SmileParserBase;

public abstract class NonBlockingParserBase
extends SmileParserBase {
    protected static final int MAJOR_INITIAL = 0;
    protected static final int MAJOR_ROOT = 1;
    protected static final int MAJOR_OBJECT_FIELD = 2;
    protected static final int MAJOR_OBJECT_VALUE = 3;
    protected static final int MAJOR_ARRAY_ELEMENT = 4;
    protected static final int MAJOR_CLOSED = 5;
    protected static final int MINOR_HEADER_INITIAL = 1;
    protected static final int MINOR_HEADER_INLINE = 2;
    protected static final int MINOR_FIELD_NAME_2BYTE = 3;
    protected static final int MINOR_FIELD_NAME_LONG = 4;
    protected static final int MINOR_FIELD_NAME_SHORT_ASCII = 5;
    protected static final int MINOR_FIELD_NAME_SHORT_UNICODE = 6;
    protected static final int MINOR_VALUE_NUMBER_INT = 7;
    protected static final int MINOR_VALUE_NUMBER_LONG = 8;
    protected static final int MINOR_VALUE_NUMBER_FLOAT = 9;
    protected static final int MINOR_VALUE_NUMBER_DOUBLE = 10;
    protected static final int MINOR_VALUE_NUMBER_BIGINT_LEN = 11;
    protected static final int MINOR_VALUE_NUMBER_BIGINT_BODY = 12;
    protected static final int MINOR_VALUE_NUMBER_BIGDEC_SCALE = 13;
    protected static final int MINOR_VALUE_NUMBER_BIGDEC_LEN = 14;
    protected static final int MINOR_VALUE_NUMBER_BIGDEC_BODY = 15;
    protected static final int MINOR_VALUE_STRING_SHORT_ASCII = 16;
    protected static final int MINOR_VALUE_STRING_SHORT_UNICODE = 17;
    protected static final int MINOR_VALUE_STRING_LONG_ASCII = 18;
    protected static final int MINOR_VALUE_STRING_LONG_UNICODE = 19;
    protected static final int MINOR_VALUE_STRING_SHARED_2BYTE = 20;
    protected static final int MINOR_VALUE_BINARY_RAW_LEN = 21;
    protected static final int MINOR_VALUE_BINARY_RAW_BODY = 22;
    protected static final int MINOR_VALUE_BINARY_7BIT_LEN = 23;
    protected static final int MINOR_VALUE_BINARY_7BIT_BODY = 24;
    protected int _majorState;
    protected int _minorState;
    protected int _majorStateAfterValue;
    protected boolean _endOfInput = false;
    protected byte[] _inputCopy;
    protected int _inputCopyLen;
    protected int _pending32;
    protected long _pending64;
    protected ByteArrayBuilder _byteArrayBuilder = null;

    protected NonBlockingParserBase(IOContext ctxt, int parserFeatures, int smileFeatures, ByteQuadsCanonicalizer sym) {
        super(ctxt, parserFeatures, smileFeatures, sym);
        this._inputCopy = ctxt.allocReadIOBuffer(500);
        this._updateTokenToNull();
        this._majorState = 0;
    }

    @Override
    public ObjectCodec getCodec() {
        return null;
    }

    @Override
    public void setCodec(ObjectCodec c) {
        throw new UnsupportedOperationException("Can not use ObjectMapper with non-blocking parser");
    }

    @Override
    public boolean canParseAsync() {
        return true;
    }

    @Override
    protected void _releaseBuffers2() {
        byte[] b = this._inputCopy;
        if (b != null) {
            this._inputCopy = null;
            this._ioContext.releaseReadIOBuffer(b);
        }
    }

    protected ByteQuadsCanonicalizer symbolTableForTests() {
        return this._symbols;
    }

    @Override
    public abstract int releaseBuffered(OutputStream var1) throws IOException;

    @Override
    public Object getInputSource() {
        return null;
    }

    @Override
    protected void _closeInput() throws IOException {
    }

    @Override
    protected void _parseNumericValue() throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT || this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return;
        }
        this._reportError("Current token (%s) not numeric, can not use numeric value accessors", (Object)this._currToken);
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    public String getText() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        JsonToken t = this._currToken;
        if (t == null || this._currToken == JsonToken.NOT_AVAILABLE) {
            return null;
        }
        if (t == JsonToken.FIELD_NAME) {
            return this._streamReadContext.getCurrentName();
        }
        if (t.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        switch (this.currentTokenId()) {
            case 6: {
                return this._textBuffer.getTextBuffer();
            }
            case 5: {
                if (!this._nameCopied) {
                    String name = this._streamReadContext.getCurrentName();
                    int nameLen = name.length();
                    if (this._nameCopyBuffer == null) {
                        this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(nameLen);
                    } else if (this._nameCopyBuffer.length < nameLen) {
                        this._nameCopyBuffer = new char[nameLen];
                    }
                    name.getChars(0, nameLen, this._nameCopyBuffer, 0);
                    this._nameCopied = true;
                }
                return this._nameCopyBuffer;
            }
            case 7: 
            case 8: {
                return this.getNumberValue().toString().toCharArray();
            }
            case -1: 
            case 0: {
                return null;
            }
        }
        return this._currToken.asCharArray();
    }

    @Override
    public int getTextLength() throws IOException {
        switch (this.currentTokenId()) {
            case 6: {
                return this._textBuffer.size();
            }
            case 5: {
                return this._streamReadContext.getCurrentName().length();
            }
            case 7: 
            case 8: {
                return this.getNumberValue().toString().length();
            }
            case -1: 
            case 0: {
                return 0;
            }
        }
        char[] ch = this._currToken.asCharArray();
        if (ch != null) {
            return ch.length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public int getText(Writer w) throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsToWriter(w);
        }
        if (this._currToken == JsonToken.NOT_AVAILABLE) {
            this._reportError("Current token not available: can not call this method");
        }
        return super.getText(w);
    }

    @Override
    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (%s) not VALUE_EMBEDDED_OBJECT, can not access as binary", (Object)this._currToken);
        }
        return this._binaryValue;
    }

    @Override
    public Object getEmbeddedObject() throws IOException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws IOException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (%s) not VALUE_EMBEDDED_OBJECT, can not access as binary", (Object)this._currToken);
        }
        out.write(this._binaryValue);
        return this._binaryValue.length;
    }

    protected final JsonToken _startArrayScope() throws IOException {
        this._streamReadContext = this._streamReadContext.createChildArrayContext(-1, -1);
        this._majorState = 4;
        this._majorStateAfterValue = 4;
        return this._updateToken(JsonToken.START_ARRAY);
    }

    protected final JsonToken _startObjectScope() throws IOException {
        this._streamReadContext = this._streamReadContext.createChildObjectContext(-1, -1);
        this._majorState = 2;
        this._majorStateAfterValue = 2;
        return this._updateToken(JsonToken.START_OBJECT);
    }

    protected final JsonToken _closeArrayScope() throws IOException {
        JsonReadContext ctxt;
        if (!this._streamReadContext.inArray()) {
            this._reportMismatchedEndMarker(93, '}');
        }
        this._streamReadContext = ctxt = this._streamReadContext.getParent();
        int st = ctxt.inObject() ? 2 : (ctxt.inArray() ? 4 : 1);
        this._majorState = st;
        this._majorStateAfterValue = st;
        return this._updateToken(JsonToken.END_ARRAY);
    }

    protected final JsonToken _closeObjectScope() throws IOException {
        JsonReadContext ctxt;
        if (!this._streamReadContext.inObject()) {
            this._reportMismatchedEndMarker(125, ']');
        }
        this._streamReadContext = ctxt = this._streamReadContext.getParent();
        int st = ctxt.inObject() ? 2 : (ctxt.inArray() ? 4 : 1);
        this._majorState = st;
        this._majorStateAfterValue = st;
        return this._updateToken(JsonToken.END_OBJECT);
    }

    protected final String _findDecodedFromSymbols(byte[] inBuf, int inPtr, int len) throws IOException {
        if (len < 5) {
            int q = inBuf[inPtr] & 0xFF;
            if (--len > 0) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (--len > 0) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    if (--len > 0) {
                        q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    }
                }
            }
            this._quad1 = q;
            return this._symbols.findName(q);
        }
        if (len < 9) {
            int q1 = (inBuf[inPtr] & 0xFF) << 8;
            q1 += inBuf[++inPtr] & 0xFF;
            q1 <<= 8;
            q1 += inBuf[++inPtr] & 0xFF;
            q1 <<= 8;
            q1 += inBuf[++inPtr] & 0xFF;
            int q2 = inBuf[++inPtr] & 0xFF;
            if ((len -= 5) > 0) {
                q2 = (q2 << 8) + (inBuf[++inPtr] & 0xFF);
                if (--len > 0) {
                    q2 = (q2 << 8) + (inBuf[++inPtr] & 0xFF);
                    if (--len > 0) {
                        q2 = (q2 << 8) + (inBuf[++inPtr] & 0xFF);
                    }
                }
            }
            this._quad1 = q1;
            this._quad2 = q2;
            return this._symbols.findName(q1, q2);
        }
        return this._findDecodedLonger(inBuf, inPtr, len);
    }

    private final String _findDecodedLonger(byte[] inBuf, int inPtr, int len) throws IOException {
        int q;
        int bufLen = len + 3 >> 2;
        if (bufLen > this._quadBuffer.length) {
            this._quadBuffer = Arrays.copyOf(this._quadBuffer, bufLen + 4);
        }
        int offset = 0;
        do {
            q = (inBuf[inPtr++] & 0xFF) << 8;
            q |= inBuf[inPtr++] & 0xFF;
            q <<= 8;
            q |= inBuf[inPtr++] & 0xFF;
            q <<= 8;
            this._quadBuffer[offset++] = q |= inBuf[inPtr++] & 0xFF;
        } while ((len -= 4) > 3);
        if (len > 0) {
            q = inBuf[inPtr] & 0xFF;
            if (--len > 0) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (--len > 0) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                }
            }
            this._quadBuffer[offset++] = q;
        }
        return this._symbols.findName(this._quadBuffer, offset);
    }

    protected final String _addDecodedToSymbols(int len, String name) throws IOException {
        if (!this._symbolsCanonical) {
            return name;
        }
        if (len < 5) {
            return this._symbols.addName(name, this._quad1);
        }
        if (len < 9) {
            return this._symbols.addName(name, this._quad1, this._quad2);
        }
        int qlen = len + 3 >> 2;
        return this._symbols.addName(name, this._quadBuffer, qlen);
    }

    protected final String[] _expandSeenNames(String[] oldShared) {
        String[] newShared;
        int len = oldShared.length;
        if (len == 0) {
            newShared = new String[64];
        } else if (len == 1024) {
            newShared = oldShared;
            this._seenNameCount = 0;
        } else {
            int newSize = len == 64 ? 256 : 1024;
            newShared = new String[newSize];
            System.arraycopy(oldShared, 0, newShared, 0, oldShared.length);
        }
        return newShared;
    }

    protected final JsonToken _eofAsNextToken() throws IOException {
        this._majorState = 5;
        if (!this._streamReadContext.inRoot()) {
            this._handleEOF();
        }
        this.close();
        return this._updateTokenToNull();
    }

    protected final JsonToken _valueComplete(JsonToken t) throws IOException {
        this._majorState = this._majorStateAfterValue;
        return this._updateToken(t);
    }

    protected final JsonToken _handleSharedString(int index) throws IOException {
        if (index >= this._seenStringValueCount) {
            this._reportInvalidSharedStringValue(index);
        }
        this._textBuffer.resetWithString(this._seenStringValues[index]);
        return this._valueComplete(JsonToken.VALUE_STRING);
    }

    protected final JsonToken _handleSharedName(int index) throws IOException {
        if (index >= this._seenNameCount) {
            this._reportInvalidSharedName(index);
        }
        this._streamReadContext.setCurrentName(this._seenNames[index]);
        this._majorState = 3;
        return this._updateToken(JsonToken.FIELD_NAME);
    }

    protected final void _addSeenStringValue(String v) throws IOException {
        if (this._seenStringValueCount < this._seenStringValues.length) {
            this._seenStringValues[this._seenStringValueCount++] = v;
            return;
        }
        this._expandSeenStringValues(v);
    }

    private final void _expandSeenStringValues(String v) {
        String[] newShared;
        String[] oldShared = this._seenStringValues;
        int len = oldShared.length;
        if (len == 0) {
            newShared = new String[64];
        } else if (len == 1024) {
            newShared = oldShared;
            this._seenStringValueCount = 0;
        } else {
            int newSize = len == 64 ? 256 : 1024;
            newShared = new String[newSize];
            System.arraycopy(oldShared, 0, newShared, 0, oldShared.length);
        }
        this._seenStringValues = newShared;
        this._seenStringValues[this._seenStringValueCount++] = v;
    }

    public void _initByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
    }

    protected void _reportMissingHeader(int unmaskedFirstByte) throws IOException {
        int b = unmaskedFirstByte & 0xFF;
        String msg = b == 123 || b == 91 ? "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(b & 0xFF) + ") -- rather, it starts with '" + (char)b + "' (plain JSON input?) -- can not parse" : "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(b & 0xFF) + ") and parser has REQUIRE_HEADER enabled: can not parse";
        throw new JsonParseException(this, msg);
    }

    protected void _reportInvalidSharedName(int index) throws IOException {
        if (this._seenNames == null) {
            this._reportError("Encountered shared name reference, even though document header explicitly declared no shared name references are included");
        }
        this._reportError("Invalid shared name reference %d; only got %d names in buffer (invalid content)", index, this._seenNameCount);
    }

    protected void _reportInvalidSharedStringValue(int index) throws IOException {
        if (this._seenStringValues == null) {
            this._reportError("Encountered shared text value reference, even though document header did not declare shared text value references may be included");
        }
        this._reportError("Invalid shared text value reference %d; only got %s names in buffer (invalid content)", index, this._seenStringValueCount);
    }

    protected void _reportInvalidInitial(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    protected void _reportInvalidOther(int mask, int ptr) throws JsonParseException {
        this._inputPtr = ptr;
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }
}

