/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.metrics.AbstractMetricsTrackState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.SizeTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.StateMetricBase;
import org.apache.flink.util.function.ThrowingConsumer;

class MetricsTrackingMapState<K, N, UK, UV>
extends AbstractMetricsTrackState<K, N, Map<UK, UV>, InternalMapState<K, N, UK, UV>, MapStateMetrics>
implements InternalMapState<K, N, UK, UV> {
    private TypeSerializer<UK> userKeySerializer;
    private TypeSerializer<UV> userValueSerializer;
    private ThrowingConsumer<UK, IOException> trackIteratorKeySizeConsumer;
    private ThrowingConsumer<UV, IOException> trackIteratorValueSizeConsumer;
    private ThrowingConsumer<Map.Entry<UK, UV>, IOException> trackIteratorKeyAndValueSizeConsumer;

    MetricsTrackingMapState(String stateName, InternalMapState<K, N, UK, UV> original, KeyedStateBackend<K> keyedStateBackend, LatencyTrackingStateConfig latencyTrackingStateConfig, SizeTrackingStateConfig sizeTrackingStateConfig) {
        super(original, keyedStateBackend, latencyTrackingStateConfig.isEnabled() ? new MapStateMetrics(stateName, latencyTrackingStateConfig.getMetricGroup(), latencyTrackingStateConfig.getSampleInterval(), latencyTrackingStateConfig.getHistorySize(), latencyTrackingStateConfig.isStateNameAsVariable()) : null, sizeTrackingStateConfig.isEnabled() ? new MapStateMetrics(stateName, sizeTrackingStateConfig.getMetricGroup(), sizeTrackingStateConfig.getSampleInterval(), sizeTrackingStateConfig.getHistorySize(), sizeTrackingStateConfig.isStateNameAsVariable()) : null);
        if (this.valueSerializer != null) {
            MapSerializer castedMapSerializer = (MapSerializer)this.valueSerializer;
            this.userKeySerializer = castedMapSerializer.getKeySerializer();
            this.userValueSerializer = castedMapSerializer.getValueSerializer();
        }
        if (sizeTrackingStateConfig.isEnabled()) {
            this.trackIteratorKeySizeConsumer = uk -> ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStateIteratorKeySize", this.sizeOfKeyAndUserKey(uk));
            this.trackIteratorValueSizeConsumer = uv -> ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStateIteratorValueSize", this.sizeOfUserValue(uv));
            this.trackIteratorKeyAndValueSizeConsumer = entry -> {
                ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStateIteratorKeySize", this.sizeOfKeyAndUserKey(entry.getKey()));
                ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStateIteratorValueSize", this.sizeOfUserValue(entry.getValue()));
            };
        }
    }

    @Override
    public UV get(UK key) throws Exception {
        Object result = this.latencyTrackingStateMetric != null && ((MapStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnGet() ? this.trackLatencyWithException(() -> ((InternalMapState)this.original).get(key), "mapStateGetLatency") : ((InternalMapState)this.original).get(key);
        if (this.sizeTrackingStateMetric != null && ((MapStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnGet()) {
            ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStateGetKeySize", this.sizeOfKeyAndUserKey(key));
            ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStateGetValueSize", this.sizeOfUserValue(result));
        }
        return result;
    }

    @Override
    public void put(UK key, UV value) throws Exception {
        if (this.sizeTrackingStateMetric != null && ((MapStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnPut()) {
            ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStatePutKeySize", this.sizeOfKeyAndUserKey(key));
            ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStatePutValueSize", this.sizeOfUserValue(value));
        }
        if (this.latencyTrackingStateMetric != null && ((MapStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnPut()) {
            this.trackLatencyWithException(() -> ((InternalMapState)this.original).put(key, value), "mapStatePutLatency");
        } else {
            ((InternalMapState)this.original).put(key, value);
        }
    }

    @Override
    public void putAll(Map<UK, UV> map) throws Exception {
        if (this.sizeTrackingStateMetric != null && ((MapStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnPutAll()) {
            for (Map.Entry<UK, UV> entry : map.entrySet()) {
                ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStatePutKeySize", this.sizeOfKeyAndUserKey(entry.getKey()));
                ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStatePutValueSize", this.sizeOfUserValue(entry.getValue()));
            }
        }
        if (this.latencyTrackingStateMetric != null && ((MapStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnPutAll()) {
            this.trackLatencyWithException(() -> ((InternalMapState)this.original).putAll(map), "mapStatePutAllLatency");
        } else {
            ((InternalMapState)this.original).putAll(map);
        }
    }

    @Override
    public void remove(UK key) throws Exception {
        if (this.sizeTrackingStateMetric != null && ((MapStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnRemove()) {
            ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStateRemoveKeySize", this.sizeOfKeyAndUserKey(key));
        }
        if (this.latencyTrackingStateMetric != null && ((MapStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnRemove()) {
            this.trackLatencyWithException(() -> ((InternalMapState)this.original).remove(key), "mapStateRemoveLatency");
        } else {
            ((InternalMapState)this.original).remove(key);
        }
    }

    @Override
    public boolean contains(UK key) throws Exception {
        if (this.sizeTrackingStateMetric != null && ((MapStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnContains()) {
            ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStateContainsKeySize", this.sizeOfKeyAndUserKey(key));
        }
        if (this.latencyTrackingStateMetric != null && ((MapStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnContains()) {
            return this.trackLatencyWithException(() -> ((InternalMapState)this.original).contains(key), "mapStateContainsLatency");
        }
        return ((InternalMapState)this.original).contains(key);
    }

    @Override
    public Iterable<Map.Entry<UK, UV>> entries() throws Exception {
        if (this.latencyTrackingStateMetric != null && ((MapStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnEntriesInit()) {
            return this.trackLatencyWithException(() -> new IterableWrapper<Map.Entry<UK, UV>>(((InternalMapState)this.original).entries(), this.trackIteratorKeyAndValueSizeConsumer), "mapStateEntriesInitLatency");
        }
        return new IterableWrapper<Map.Entry<UK, UV>>(((InternalMapState)this.original).entries(), this.trackIteratorKeyAndValueSizeConsumer);
    }

    @Override
    public Iterable<UK> keys() throws Exception {
        if (this.latencyTrackingStateMetric != null && ((MapStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnKeysInit()) {
            return this.trackLatencyWithException(() -> new IterableWrapper(((InternalMapState)this.original).keys(), this.trackIteratorKeySizeConsumer), "mapStateKeysInitLatency");
        }
        return new IterableWrapper(((InternalMapState)this.original).keys(), this.trackIteratorKeySizeConsumer);
    }

    @Override
    public Iterable<UV> values() throws Exception {
        if (this.latencyTrackingStateMetric != null && ((MapStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnValuesInit()) {
            return this.trackLatencyWithException(() -> new IterableWrapper(((InternalMapState)this.original).values(), this.trackIteratorValueSizeConsumer), "mapStateValuesInitLatency");
        }
        return new IterableWrapper(((InternalMapState)this.original).values(), this.trackIteratorValueSizeConsumer);
    }

    @Override
    public Iterator<Map.Entry<UK, UV>> iterator() throws Exception {
        if (this.latencyTrackingStateMetric != null && ((MapStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnIteratorInit()) {
            return this.trackLatencyWithException(() -> new IteratorWrapper<Map.Entry<UK, UV>>(((InternalMapState)this.original).iterator(), this.trackIteratorKeyAndValueSizeConsumer), "mapStateIteratorInitLatency");
        }
        return new IteratorWrapper<Map.Entry<UK, UV>>(((InternalMapState)this.original).iterator(), this.trackIteratorKeyAndValueSizeConsumer);
    }

    @Override
    public boolean isEmpty() throws Exception {
        if (this.sizeTrackingStateMetric != null && ((MapStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnIsEmpty()) {
            ((MapStateMetrics)this.sizeTrackingStateMetric).updateMetrics("mapStateIsEmptyKeySize", super.sizeOfKey());
        }
        if (this.latencyTrackingStateMetric != null && ((MapStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnIsEmpty()) {
            return this.trackLatencyWithException(() -> ((InternalMapState)this.original).isEmpty(), "mapStateIsEmptyLatency");
        }
        return ((InternalMapState)this.original).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sizeOfKeyAndUserKey(UK userKey) throws IOException {
        long userKeySize;
        if (this.userKeySerializer == null || userKey == null) {
            return super.sizeOfKey();
        }
        if (this.userKeySerializer.getLength() == -1) {
            try {
                this.userKeySerializer.serialize(userKey, this.outputSerializer);
                userKeySize = this.outputSerializer.length();
            }
            finally {
                this.outputSerializer.clear();
            }
        } else {
            userKeySize = this.userKeySerializer.getLength();
        }
        return super.sizeOfKey() + userKeySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sizeOfUserValue(UV userValue) throws IOException {
        long userValueSize;
        if (this.userValueSerializer == null || userValue == null) {
            return 0L;
        }
        if (this.userValueSerializer.getLength() == -1) {
            try {
                this.userValueSerializer.serialize(userValue, this.outputSerializer);
                userValueSize = this.outputSerializer.length();
            }
            finally {
                this.outputSerializer.clear();
            }
        } else {
            userValueSize = this.userValueSerializer.getLength();
        }
        return userValueSize;
    }

    static class MapStateMetrics
    extends StateMetricBase {
        private static final String MAP_STATE_GET_LATENCY = "mapStateGetLatency";
        private static final String MAP_STATE_PUT_LATENCY = "mapStatePutLatency";
        private static final String MAP_STATE_PUT_ALL_LATENCY = "mapStatePutAllLatency";
        private static final String MAP_STATE_REMOVE_LATENCY = "mapStateRemoveLatency";
        private static final String MAP_STATE_CONTAINS_LATENCY = "mapStateContainsLatency";
        private static final String MAP_STATE_ENTRIES_INIT_LATENCY = "mapStateEntriesInitLatency";
        private static final String MAP_STATE_KEYS_INIT_LATENCY = "mapStateKeysInitLatency";
        private static final String MAP_STATE_VALUES_INIT_LATENCY = "mapStateValuesInitLatency";
        private static final String MAP_STATE_ITERATOR_INIT_LATENCY = "mapStateIteratorInitLatency";
        private static final String MAP_STATE_IS_EMPTY_LATENCY = "mapStateIsEmptyLatency";
        private static final String MAP_STATE_ITERATOR_HAS_NEXT_LATENCY = "mapStateIteratorHasNextLatency";
        private static final String MAP_STATE_ITERATOR_NEXT_LATENCY = "mapStateIteratorNextLatency";
        private static final String MAP_STATE_ITERATOR_REMOVE_LATENCY = "mapStateIteratorRemoveLatency";
        private static final String MAP_STATE_GET_KEY_SIZE = "mapStateGetKeySize";
        private static final String MAP_STATE_GET_VALUE_SIZE = "mapStateGetValueSize";
        private static final String MAP_STATE_PUT_KEY_SIZE = "mapStatePutKeySize";
        private static final String MAP_STATE_PUT_VALUE_SIZE = "mapStatePutValueSize";
        private static final String MAP_STATE_ITERATOR_KEY_SIZE = "mapStateIteratorKeySize";
        private static final String MAP_STATE_ITERATOR_VALUE_SIZE = "mapStateIteratorValueSize";
        private static final String MAP_STATE_REMOVE_KEY_SIZE = "mapStateRemoveKeySize";
        private static final String MAP_STATE_CONTAINS_KEY_SIZE = "mapStateContainsKeySize";
        private static final String MAP_STATE_IS_EMPTY_KEY_SIZE = "mapStateIsEmptyKeySize";
        private int getCount = 0;
        private int iteratorRemoveCount = 0;
        private int putCount = 0;
        private int putAllCount = 0;
        private int removeCount = 0;
        private int containsCount = 0;
        private int entriesInitCount = 0;
        private int keysInitCount = 0;
        private int valuesInitCount = 0;
        private int isEmptyCount = 0;
        private int iteratorInitCount = 0;
        private int iteratorHasNextCount = 0;
        private int iteratorNextCount = 0;

        private MapStateMetrics(String stateName, MetricGroup metricGroup, int sampleInterval, int historySize, boolean stateNameAsVariable) {
            super(stateName, metricGroup, sampleInterval, historySize, stateNameAsVariable);
        }

        int getGetCount() {
            return this.getCount;
        }

        int getIteratorRemoveCount() {
            return this.iteratorRemoveCount;
        }

        int getPutCount() {
            return this.putCount;
        }

        int getPutAllCount() {
            return this.putAllCount;
        }

        int getRemoveCount() {
            return this.removeCount;
        }

        int getContainsCount() {
            return this.containsCount;
        }

        int getEntriesInitCount() {
            return this.entriesInitCount;
        }

        int getKeysInitCount() {
            return this.keysInitCount;
        }

        int getValuesInitCount() {
            return this.valuesInitCount;
        }

        int getIsEmptyCount() {
            return this.isEmptyCount;
        }

        int getIteratorInitCount() {
            return this.iteratorInitCount;
        }

        int getIteratorHasNextCount() {
            return this.iteratorHasNextCount;
        }

        @VisibleForTesting
        void resetIteratorHasNextCount() {
            this.iteratorHasNextCount = 0;
        }

        int getIteratorNextCount() {
            return this.iteratorNextCount;
        }

        private boolean trackMetricsOnGet() {
            this.getCount = this.loopUpdateCounter(this.getCount);
            return this.getCount == 1;
        }

        private boolean trackMetricsOnPut() {
            this.putCount = this.loopUpdateCounter(this.putCount);
            return this.putCount == 1;
        }

        private boolean trackMetricsOnPutAll() {
            this.putAllCount = this.loopUpdateCounter(this.putAllCount);
            return this.putAllCount == 1;
        }

        private boolean trackMetricsOnRemove() {
            this.removeCount = this.loopUpdateCounter(this.removeCount);
            return this.removeCount == 1;
        }

        private boolean trackMetricsOnContains() {
            this.containsCount = this.loopUpdateCounter(this.containsCount);
            return this.containsCount == 1;
        }

        private boolean trackMetricsOnEntriesInit() {
            this.entriesInitCount = this.loopUpdateCounter(this.entriesInitCount);
            return this.entriesInitCount == 1;
        }

        private boolean trackMetricsOnKeysInit() {
            this.keysInitCount = this.loopUpdateCounter(this.keysInitCount);
            return this.keysInitCount == 1;
        }

        private boolean trackMetricsOnValuesInit() {
            this.valuesInitCount = this.loopUpdateCounter(this.valuesInitCount);
            return this.valuesInitCount == 1;
        }

        private boolean trackMetricsOnIteratorInit() {
            this.iteratorInitCount = this.loopUpdateCounter(this.iteratorInitCount);
            return this.iteratorInitCount == 1;
        }

        private boolean trackMetricsOnIsEmpty() {
            this.isEmptyCount = this.loopUpdateCounter(this.isEmptyCount);
            return this.isEmptyCount == 1;
        }

        private boolean trackMetricsOnIteratorHasNext() {
            this.iteratorHasNextCount = this.loopUpdateCounter(this.iteratorHasNextCount);
            return this.iteratorHasNextCount == 1;
        }

        private boolean trackMetricsOnIteratorNext() {
            this.iteratorNextCount = this.loopUpdateCounter(this.iteratorNextCount);
            return this.iteratorNextCount == 1;
        }

        private boolean trackMetricsOnIteratorRemove() {
            this.iteratorRemoveCount = this.loopUpdateCounter(this.iteratorRemoveCount);
            return this.iteratorRemoveCount == 1;
        }
    }

    private class IteratorWrapper<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;
        private final ThrowingConsumer<E, IOException> trackElementSizeConsumer;

        IteratorWrapper(Iterator<E> iterator, ThrowingConsumer<E, IOException> trackElementSize) {
            this.iterator = iterator;
            this.trackElementSizeConsumer = trackElementSize;
        }

        @Override
        public boolean hasNext() {
            if (MetricsTrackingMapState.this.latencyTrackingStateMetric != null && ((MapStateMetrics)MetricsTrackingMapState.this.latencyTrackingStateMetric).trackMetricsOnIteratorHasNext()) {
                return MetricsTrackingMapState.this.trackLatency(this.iterator::hasNext, "mapStateIteratorHasNextLatency");
            }
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            Object result = MetricsTrackingMapState.this.latencyTrackingStateMetric != null && ((MapStateMetrics)MetricsTrackingMapState.this.latencyTrackingStateMetric).trackMetricsOnIteratorNext() ? MetricsTrackingMapState.this.trackLatency(this.iterator::next, "mapStateIteratorNextLatency") : this.iterator.next();
            if (MetricsTrackingMapState.this.sizeTrackingStateMetric != null && ((MapStateMetrics)MetricsTrackingMapState.this.sizeTrackingStateMetric).trackMetricsOnIteratorNext()) {
                try {
                    this.trackElementSizeConsumer.accept(result);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }

        @Override
        public void remove() {
            if (MetricsTrackingMapState.this.latencyTrackingStateMetric != null && ((MapStateMetrics)MetricsTrackingMapState.this.latencyTrackingStateMetric).trackMetricsOnIteratorRemove()) {
                MetricsTrackingMapState.this.trackLatency(this.iterator::remove, "mapStateIteratorRemoveLatency");
            } else {
                this.iterator.remove();
            }
        }
    }

    private class IterableWrapper<E>
    implements Iterable<E> {
        private final Iterable<E> iterable;
        private final ThrowingConsumer<E, IOException> trackElementSizeConsumer;

        IterableWrapper(Iterable<E> iterable, ThrowingConsumer<E, IOException> trackElementSizeConsumer) {
            this.iterable = iterable;
            this.trackElementSizeConsumer = trackElementSizeConsumer;
        }

        @Override
        public Iterator<E> iterator() {
            return new IteratorWrapper<E>(this.iterable.iterator(), this.trackElementSizeConsumer);
        }
    }
}

