/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.GateBuffersSpec;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateSpecUtils;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.util.Preconditions;

public class NettyShuffleUtils {
    public static int getNetworkBuffersPerInputChannel(int configuredNetworkBuffersPerChannel) {
        return configuredNetworkBuffersPerChannel;
    }

    public static Pair<Integer, Integer> getMinMaxFloatingBuffersPerInputGate(int numFloatingBuffersPerGate) {
        return Pair.of((Object)1, (Object)numFloatingBuffersPerGate);
    }

    public static Pair<Integer, Integer> getMinMaxNetworkBuffersPerResultPartition(int configuredNetworkBuffersPerChannel, int numFloatingBuffersPerGate, int sortShuffleMinParallelism, int sortShuffleMinBuffers, int numSubpartitions, boolean enableTieredStorage, int tieredStoreExclusiveBuffers, ResultPartitionType type) {
        int min;
        boolean isSortShuffle;
        boolean bl = isSortShuffle = type.isBlockingOrBlockingPersistentResultPartition() && numSubpartitions >= sortShuffleMinParallelism;
        if (isSortShuffle) {
            min = sortShuffleMinBuffers;
        } else {
            int n = min = enableTieredStorage ? Math.min(tieredStoreExclusiveBuffers, numSubpartitions + 1) : numSubpartitions + 1;
        }
        int max = type.isBounded() ? numSubpartitions * configuredNetworkBuffersPerChannel + numFloatingBuffersPerGate : (isSortShuffle ? Math.max(min, 4 * numSubpartitions) : Integer.MAX_VALUE);
        return Pair.of((Object)min, (Object)Math.max(min, max));
    }

    public static int computeNetworkBuffersForAnnouncing(int numBuffersPerChannel, int numFloatingBuffersPerGate, Optional<Integer> maxRequiredBuffersPerGate, int sortShuffleMinParallelism, int sortShuffleMinBuffers, Map<IntermediateDataSetID, Integer> inputChannelNums, Map<IntermediateDataSetID, Integer> partitionReuseCount, Map<IntermediateDataSetID, Integer> subpartitionNums, Map<IntermediateDataSetID, ResultPartitionType> inputPartitionTypes, Map<IntermediateDataSetID, ResultPartitionType> partitionTypes) {
        int requirementForInputs = 0;
        for (IntermediateDataSetID dataSetId : inputChannelNums.keySet()) {
            int numChannels = inputChannelNums.get(dataSetId);
            ResultPartitionType inputPartitionType = inputPartitionTypes.get(dataSetId);
            Preconditions.checkNotNull(inputPartitionType);
            int numSingleGateBuffers = NettyShuffleUtils.getNumBuffersToAnnounceForInputGate(inputPartitionType, numBuffersPerChannel, numFloatingBuffersPerGate, maxRequiredBuffersPerGate, numChannels);
            Preconditions.checkState(partitionReuseCount.containsKey(dataSetId));
            requirementForInputs += numSingleGateBuffers * partitionReuseCount.get(dataSetId);
        }
        int requirementForOutputs = 0;
        for (IntermediateDataSetID dataSetId : subpartitionNums.keySet()) {
            int numSubs = subpartitionNums.get(dataSetId);
            ResultPartitionType partitionType = partitionTypes.get(dataSetId);
            Preconditions.checkNotNull(partitionType);
            requirementForOutputs += NettyShuffleUtils.getNumBuffersToAnnounceForResultPartition(partitionType, numBuffersPerChannel, numFloatingBuffersPerGate, sortShuffleMinParallelism, sortShuffleMinBuffers, numSubs);
        }
        return requirementForInputs + requirementForOutputs;
    }

    private static int getNumBuffersToAnnounceForInputGate(ResultPartitionType type, int configuredNetworkBuffersPerChannel, int floatingNetworkBuffersPerGate, Optional<Integer> maxRequiredBuffersPerGate, int numInputChannels) {
        GateBuffersSpec gateBuffersSpec = InputGateSpecUtils.createGateBuffersSpec(maxRequiredBuffersPerGate, configuredNetworkBuffersPerChannel, floatingNetworkBuffersPerGate, type, numInputChannels, false);
        return gateBuffersSpec.targetTotalBuffersPerGate();
    }

    private static int getNumBuffersToAnnounceForResultPartition(ResultPartitionType type, int configuredNetworkBuffersPerChannel, int floatingBuffersPerGate, int sortShuffleMinParallelism, int sortShuffleMinBuffers, int numSubpartitions) {
        Pair<Integer, Integer> minAndMax = NettyShuffleUtils.getMinMaxNetworkBuffersPerResultPartition(configuredNetworkBuffersPerChannel, floatingBuffersPerGate, sortShuffleMinParallelism, sortShuffleMinBuffers, numSubpartitions, false, 0, type);
        int ret = type.canBePipelinedConsumed() ? (Integer)minAndMax.getRight() : (Integer)minAndMax.getLeft();
        if (ret == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal to announce network memory requirement as Integer.MAX_VALUE, partition type: " + String.valueOf((Object)type));
        }
        return ret;
    }

    private NettyShuffleUtils() {
    }
}

