/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.EventOptions;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.configuration.TraceOptions;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.events.EventBuilder;
import org.apache.flink.events.reporter.EventReporter;
import org.apache.flink.events.reporter.EventReporterFactory;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.Reporter;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.apache.flink.runtime.metrics.AbstractReporterSetup;
import org.apache.flink.runtime.metrics.EventReporterSetup;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.TraceReporterSetup;
import org.apache.flink.runtime.metrics.filter.ReporterFilter;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.traces.SpanBuilder;
import org.apache.flink.traces.reporter.TraceReporter;
import org.apache.flink.traces.reporter.TraceReporterFactory;
import org.apache.flink.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterSetupBuilder<REPORTED, REPORTER extends Reporter, SETUP extends AbstractReporterSetup<REPORTER, REPORTED>, REPORTER_FACTORY> {
    private static final Logger LOG = LoggerFactory.getLogger(ReporterSetupBuilder.class);
    private static final Pattern LIST_PATTERN = Pattern.compile("\\s*,\\s*");
    public static final ReporterSetupBuilder<Metric, MetricReporter, ReporterSetup, MetricReporterFactory> METRIC_SETUP_BUILDER = new ReporterSetupBuilder(new ReporterSetupInfo(MetricReporter.class, MetricReporterFactory.class, "metrics.reporter.", MetricOptions.REPORTER_FACTORY_CLASS, MetricOptions.REPORTERS_LIST, MetricOptions.REPORTER_ADDITIONAL_VARIABLES, ReporterSetupBuilder.createReporterClassPattern(Pattern.quote("metrics.reporter."), "(" + Pattern.quote(MetricOptions.REPORTER_FACTORY_CLASS.key()) + ")"), LIST_PATTERN, MetricReporterFactory::createMetricReporter, ReporterSetup::new));
    public static final ReporterSetupBuilder<SpanBuilder, TraceReporter, TraceReporterSetup, TraceReporterFactory> TRACE_SETUP_BUILDER = new ReporterSetupBuilder(new ReporterSetupInfo(TraceReporter.class, TraceReporterFactory.class, "traces.reporter.", TraceOptions.REPORTER_FACTORY_CLASS, TraceOptions.TRACE_REPORTERS_LIST, TraceOptions.REPORTER_ADDITIONAL_VARIABLES, ReporterSetupBuilder.createReporterClassPattern(Pattern.quote("traces.reporter."), Pattern.quote(TraceOptions.REPORTER_FACTORY_CLASS.key())), LIST_PATTERN, TraceReporterFactory::createTraceReporter, TraceReporterSetup::new));
    public static final ReporterSetupBuilder<EventBuilder, EventReporter, EventReporterSetup, EventReporterFactory> EVENT_SETUP_BUILDER = new ReporterSetupBuilder(new ReporterSetupInfo(EventReporter.class, EventReporterFactory.class, "events.reporter.", EventOptions.REPORTER_FACTORY_CLASS, EventOptions.REPORTERS_LIST, EventOptions.REPORTER_ADDITIONAL_VARIABLES, ReporterSetupBuilder.createReporterClassPattern(Pattern.quote("events.reporter."), Pattern.quote(EventOptions.REPORTER_FACTORY_CLASS.key())), LIST_PATTERN, EventReporterFactory::createEventReporter, EventReporterSetup::new));
    private final ReporterSetupInfo<REPORTED, REPORTER, SETUP, REPORTER_FACTORY> reporterSetupInfo;

    private static Pattern createReporterClassPattern(String prefix, String suffix) {
        return Pattern.compile(prefix + "([\\S&&[^.]]*)\\." + suffix);
    }

    ReporterSetupBuilder(ReporterSetupInfo<REPORTED, REPORTER, SETUP, REPORTER_FACTORY> reporterSetupInfo) {
        this.reporterSetupInfo = reporterSetupInfo;
    }

    @VisibleForTesting
    public SETUP forReporter(String reporterName, REPORTER reporter) {
        return this.forReporter(reporterName, new MetricConfig(), reporter);
    }

    @VisibleForTesting
    public SETUP forReporter(String reporterName, REPORTER reporter, ReporterFilter<REPORTED> reporterFilter) {
        return this.createReporterSetup(reporterName, new MetricConfig(), reporter, reporterFilter, Collections.emptyMap());
    }

    @VisibleForTesting
    public SETUP forReporter(String reporterName, MetricConfig metricConfig, REPORTER reporter) {
        return this.createReporterSetup(reporterName, metricConfig, reporter, ReporterFilter.getNoOpFilter(), Collections.emptyMap());
    }

    @VisibleForTesting
    public SETUP forReporter(String reporterName, MetricConfig metricConfig, REPORTER reporter, ReporterFilter<REPORTED> reporterFilter, Map<String, String> additionalVariables) {
        return this.createReporterSetup(reporterName, metricConfig, reporter, reporterFilter, additionalVariables);
    }

    @VisibleForTesting
    public SETUP forReporter(String reporterName, MetricConfig metricConfig, REPORTER reporter, ReporterFilter<REPORTED> reporterFilter) {
        return this.createReporterSetup(reporterName, metricConfig, reporter, reporterFilter, Collections.emptyMap());
    }

    private SETUP createReporterSetup(String reporterName, MetricConfig metricConfig, REPORTER reporter, ReporterFilter<REPORTED> reporterFilter, Map<String, String> additionalVariables) {
        reporter.open(metricConfig);
        return (SETUP)((AbstractReporterSetup)this.reporterSetupInfo.reporterSetupFactory.createReporterSetup(reporterName, metricConfig, reporter, reporterFilter, additionalVariables));
    }

    public List<SETUP> fromConfiguration(Configuration configuration, Function<Configuration, ReporterFilter<REPORTED>> filterFactory, @Nullable PluginManager pluginManager) {
        Set<String> namedReporters = this.findEnabledReportersInConfiguration(configuration);
        if (namedReporters.isEmpty()) {
            return Collections.emptyList();
        }
        List<Tuple2<String, Configuration>> reporterConfigurations = this.loadReporterConfigurations(configuration, namedReporters);
        Map<String, REPORTER_FACTORY> reporterFactories = this.loadAvailableReporterFactories(pluginManager);
        return this.setupReporters(reporterFactories, filterFactory, reporterConfigurations);
    }

    private Map<String, REPORTER_FACTORY> loadAvailableReporterFactories(@Nullable PluginManager pluginManager) {
        HashMap<String, REPORTER_FACTORY> reporterFactories = CollectionUtil.newHashMapWithExpectedSize(2);
        Iterator<REPORTER_FACTORY> factoryIterator = this.getAllReporterFactories(pluginManager);
        while (factoryIterator.hasNext()) {
            try {
                REPORTER_FACTORY factory = factoryIterator.next();
                String factoryClassName = factory.getClass().getName();
                Object existingFactory = reporterFactories.get(factoryClassName);
                if (existingFactory == null) {
                    reporterFactories.put(factoryClassName, factory);
                    LOG.debug("Found {} {} at {} ", new Object[]{this.reporterSetupInfo.factoryTypeClass.getSimpleName(), factoryClassName, new File(factory.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getCanonicalPath()});
                    continue;
                }
                LOG.warn("Multiple implementations of the same {} were found in 'lib' and/or 'plugins' directories for {}. It is recommended to remove redundant reporter JARs to resolve used versions' ambiguity.", (Object)this.reporterSetupInfo.factoryTypeClass.getSimpleName(), (Object)factoryClassName);
            }
            catch (Exception | ServiceConfigurationError e) {
                LOG.warn("Error while loading {}.", (Object)this.reporterSetupInfo.factoryTypeClass.getSimpleName(), (Object)e);
            }
        }
        return Collections.unmodifiableMap(reporterFactories);
    }

    private Iterator<REPORTER_FACTORY> getAllReporterFactories(@Nullable PluginManager pluginManager) {
        Spliterator factoryIteratorSPI = ServiceLoader.load(this.reporterSetupInfo.factoryTypeClass).spliterator();
        Spliterator factoryIteratorPlugins = pluginManager != null ? Spliterators.spliteratorUnknownSize(pluginManager.load(this.reporterSetupInfo.factoryTypeClass), 0) : Spliterators.emptySpliterator();
        return Stream.concat(StreamSupport.stream(factoryIteratorPlugins, false), StreamSupport.stream(factoryIteratorSPI, false)).iterator();
    }

    private List<SETUP> setupReporters(Map<String, REPORTER_FACTORY> reporterFactories, Function<Configuration, ReporterFilter<REPORTED>> filterFactory, List<Tuple2<String, Configuration>> reporterConfigurations) {
        ArrayList reporterSetups = new ArrayList(reporterConfigurations.size());
        for (Tuple2<String, Configuration> reporterConfiguration : reporterConfigurations) {
            String reporterName = (String)reporterConfiguration.f0;
            Configuration reporterConfig = (Configuration)reporterConfiguration.f1;
            try {
                Optional<REPORTER> metricReporterOptional = this.loadReporter(reporterName, reporterConfig, reporterFactories);
                ReporterFilter<REPORTED> reporterFilter = filterFactory.apply(reporterConfig);
                Map<String, String> additionalVariables = reporterConfig.get(this.reporterSetupInfo.reporterAdditionalVariables).entrySet().stream().collect(Collectors.toMap(e -> ScopeFormat.asVariable((String)e.getKey()), Map.Entry::getValue));
                metricReporterOptional.ifPresent(reporter -> {
                    MetricConfig metricConfig = new MetricConfig();
                    reporterConfig.addAllToProperties((Properties)metricConfig);
                    reporterSetups.add(this.createReporterSetup(reporterName, metricConfig, reporter, reporterFilter, additionalVariables));
                });
            }
            catch (Throwable t) {
                LOG.error("Could not instantiate {} {}. Reporting might not be exposed.", new Object[]{this.reporterSetupInfo.reporterTypeClass.getSimpleName(), reporterName, t});
            }
        }
        return reporterSetups;
    }

    private Optional<REPORTER> loadReporter(String reporterName, Configuration reporterConfig, Map<String, REPORTER_FACTORY> reporterFactories) {
        String factoryClassName = reporterConfig.get(this.reporterSetupInfo.factoryClassConfig);
        if (factoryClassName != null) {
            return this.loadViaFactory(factoryClassName, reporterName, reporterConfig, reporterFactories);
        }
        LOG.warn("No reporter factory set for reporter {}. Events might not be exposed/reported.", (Object)reporterName);
        return Optional.empty();
    }

    private Optional<REPORTER> loadViaFactory(String factoryClassName, String reporterName, Configuration reporterConfig, Map<String, REPORTER_FACTORY> reporterFactories) {
        REPORTER_FACTORY factory = reporterFactories.get(factoryClassName);
        if (factory == null) {
            LOG.warn("The reporter factory ({}) could not be found for reporter {}. Available factories: {}.", new Object[]{factoryClassName, reporterName, reporterFactories.keySet()});
            return Optional.empty();
        }
        return this.loadViaFactory(reporterConfig, factory);
    }

    private Optional<REPORTER> loadViaFactory(Configuration reporterConfig, REPORTER_FACTORY factory) {
        MetricConfig metricConfig = new MetricConfig();
        reporterConfig.addAllToProperties((Properties)metricConfig);
        return Optional.of((Reporter)this.reporterSetupInfo.reporterFactoryAdapter.invoke(factory, metricConfig));
    }

    private List<Tuple2<String, Configuration>> loadReporterConfigurations(Configuration configuration, Set<String> namedReporters) {
        ArrayList<Tuple2<String, Configuration>> reporterConfigurations = new ArrayList<Tuple2<String, Configuration>>(namedReporters.size());
        for (String namedReporter : namedReporters) {
            DelegatingConfiguration delegatingConfiguration = new DelegatingConfiguration(configuration, this.reporterSetupInfo.reporterPrefix + namedReporter + ".");
            reporterConfigurations.add(Tuple2.of(namedReporter, delegatingConfiguration));
        }
        return reporterConfigurations;
    }

    private Set<String> findEnabledReportersInConfiguration(Configuration configuration) {
        String includedReportersString = configuration.get(this.reporterSetupInfo.reportersList, "");
        Set includedReporters = this.reporterSetupInfo.reporterListPattern.splitAsStream(includedReportersString).filter(r -> !r.isEmpty()).collect(Collectors.toSet());
        TreeSet<String> namedOrderedReporters = new TreeSet<String>(String::compareTo);
        for (String key : configuration.keySet()) {
            Matcher matcher;
            if (!key.startsWith(this.reporterSetupInfo.reporterPrefix) || !(matcher = this.reporterSetupInfo.reporterClassPattern.matcher(key)).matches()) continue;
            String reporterName = matcher.group(1);
            if (includedReporters.isEmpty() || includedReporters.contains(reporterName)) {
                if (namedOrderedReporters.contains(reporterName)) {
                    LOG.warn("Duplicate class configuration detected for {}{}.", (Object)this.reporterSetupInfo.reporterPrefix.replace('.', ' '), (Object)reporterName);
                    continue;
                }
                namedOrderedReporters.add(reporterName);
                continue;
            }
            LOG.info("Excluding {}{}, not configured in reporter list ({}).", new Object[]{this.reporterSetupInfo.reporterPrefix.replace('.', ' '), reporterName, includedReportersString});
        }
        return namedOrderedReporters;
    }

    static class ReporterSetupInfo<REPORTED, REPORTER extends Reporter, SETUP extends AbstractReporterSetup<REPORTER, REPORTED>, REPORTER_FACTORY> {
        Class<REPORTER> reporterTypeClass;
        Class<REPORTER_FACTORY> factoryTypeClass;
        String reporterPrefix;
        ConfigOption<String> factoryClassConfig;
        ConfigOption<String> reportersList;
        ConfigOption<Map<String, String>> reporterAdditionalVariables;
        Pattern reporterClassPattern;
        Pattern reporterListPattern;
        ReporterFactoryAdapter<REPORTER_FACTORY, REPORTER> reporterFactoryAdapter;
        ReporterSetupFactory<SETUP, REPORTER, REPORTED> reporterSetupFactory;

        ReporterSetupInfo(Class<REPORTER> reporterTypeClass, Class<REPORTER_FACTORY> factoryTypeClass, String reporterPrefix, ConfigOption<String> factoryClassConfig, ConfigOption<String> reportersList, ConfigOption<Map<String, String>> reporterAdditionalVariables, Pattern reporterClassPattern, Pattern reporterListPattern, ReporterFactoryAdapter<REPORTER_FACTORY, REPORTER> reporterFactoryAdapter, ReporterSetupFactory<SETUP, REPORTER, REPORTED> reporterSetupFactory) {
            this.reporterTypeClass = reporterTypeClass;
            this.factoryTypeClass = factoryTypeClass;
            this.reporterPrefix = reporterPrefix;
            this.factoryClassConfig = factoryClassConfig;
            this.reportersList = reportersList;
            this.reporterAdditionalVariables = reporterAdditionalVariables;
            this.reporterClassPattern = reporterClassPattern;
            this.reporterListPattern = reporterListPattern;
            this.reporterFactoryAdapter = reporterFactoryAdapter;
            this.reporterSetupFactory = reporterSetupFactory;
        }
    }

    static interface ReporterSetupFactory<SETUP, REPORTER, REPORTED> {
        public SETUP createReporterSetup(String var1, MetricConfig var2, REPORTER var3, ReporterFilter<REPORTED> var4, Map<String, String> var5);
    }

    @FunctionalInterface
    static interface ReporterFactoryAdapter<REPORTER_FACTORY, REPORTER> {
        public REPORTER invoke(REPORTER_FACTORY var1, MetricConfig var2);
    }
}

