/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PendingRequest;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;
import org.apache.flink.runtime.scheduler.loading.LoadingWeight;
import org.apache.flink.util.Preconditions;

public class PreferredAllocationRequestSlotMatchingStrategy
implements RequestSlotMatchingStrategy {
    @Nonnull
    private final RequestSlotMatchingStrategy rollbackStrategy;

    private PreferredAllocationRequestSlotMatchingStrategy(RequestSlotMatchingStrategy rollbackStrategy) {
        this.rollbackStrategy = Preconditions.checkNotNull(rollbackStrategy);
    }

    public static RequestSlotMatchingStrategy create(RequestSlotMatchingStrategy rollbackStrategy) {
        return new PreferredAllocationRequestSlotMatchingStrategy(rollbackStrategy);
    }

    @Override
    public Collection<RequestSlotMatchingStrategy.RequestSlotMatch> matchRequestsAndSlots(Collection<? extends PhysicalSlot> slots, Collection<PendingRequest> pendingRequests, Map<ResourceID, LoadingWeight> taskExecutorsLoadingWeight) {
        ArrayList<RequestSlotMatchingStrategy.RequestSlotMatch> requestSlotMatches = new ArrayList<RequestSlotMatchingStrategy.RequestSlotMatch>();
        Map freeSlots = slots.stream().collect(Collectors.toMap(SlotInfo::getAllocationId, Function.identity()));
        HashMap<SlotRequestId, PendingRequest> pendingRequestsWithPreferredAllocations = new HashMap<SlotRequestId, PendingRequest>();
        ArrayList<PendingRequest> unmatchedRequests = new ArrayList<PendingRequest>();
        for (PendingRequest pendingRequest : pendingRequests) {
            if (pendingRequest.getPreferredAllocations().isEmpty()) {
                unmatchedRequests.add(pendingRequest);
                continue;
            }
            pendingRequestsWithPreferredAllocations.put(pendingRequest.getSlotRequestId(), pendingRequest);
        }
        Iterator freeSlotsIterator = freeSlots.values().iterator();
        block1: while (freeSlotsIterator.hasNext() && !pendingRequestsWithPreferredAllocations.isEmpty()) {
            PhysicalSlot freeSlot = (PhysicalSlot)freeSlotsIterator.next();
            Iterator pendingRequestIterator = pendingRequestsWithPreferredAllocations.values().iterator();
            while (pendingRequestIterator.hasNext()) {
                PendingRequest pendingRequest = (PendingRequest)pendingRequestIterator.next();
                if (!freeSlot.getResourceProfile().isMatching(pendingRequest.getResourceProfile()) || !pendingRequest.getPreferredAllocations().contains(freeSlot.getAllocationId())) continue;
                requestSlotMatches.add(RequestSlotMatchingStrategy.RequestSlotMatch.createFor(pendingRequest, freeSlot));
                LoadingWeight deltaLoading = pendingRequest.getLoading();
                taskExecutorsLoadingWeight.compute(freeSlot.getTaskManagerLocation().getResourceID(), (ignoredId, oldLoad) -> oldLoad == null ? deltaLoading : deltaLoading.merge((LoadingWeight)oldLoad));
                pendingRequestIterator.remove();
                freeSlotsIterator.remove();
                continue block1;
            }
        }
        unmatchedRequests.addAll(pendingRequestsWithPreferredAllocations.values());
        if (!freeSlots.isEmpty() && !unmatchedRequests.isEmpty()) {
            requestSlotMatches.addAll(this.rollbackStrategy.matchRequestsAndSlots(freeSlots.values(), unmatchedRequests, taskExecutorsLoadingWeight));
        }
        return requestSlotMatches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreferredAllocationRequestSlotMatchingStrategy that = (PreferredAllocationRequestSlotMatchingStrategy)o;
        return Objects.equals(this.rollbackStrategy, that.rollbackStrategy);
    }

    public String toString() {
        return PreferredAllocationRequestSlotMatchingStrategy.class.getSimpleName();
    }
}

