/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.externalresource;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.externalresource.ExternalResourceDriver;
import org.apache.flink.api.common.externalresource.ExternalResourceDriverFactory;
import org.apache.flink.api.common.externalresource.ExternalResourceInfo;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.externalresource.StaticExternalResourceInfoProvider;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalResourceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalResourceUtils.class);

    private ExternalResourceUtils() {
        throw new UnsupportedOperationException("This class should never be instantiated.");
    }

    private static Set<String> getExternalResourceSet(Configuration config) {
        if (config.getValue(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST).equals("none")) {
            return Collections.emptySet();
        }
        return new HashSet<String>((Collection)config.get(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST));
    }

    public static Map<String, String> getExternalResourceConfigurationKeys(Configuration config, String suffix) {
        Set<String> resourceSet = ExternalResourceUtils.getExternalResourceSet(config);
        HashMap<String, String> configKeysToResourceNameMap = new HashMap<String, String>();
        LOG.info("Enabled external resources: {}", resourceSet);
        if (resourceSet.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> externalResourceConfigs = new HashMap<String, String>();
        for (String resourceName : resourceSet) {
            ConfigOption<String> configKeyOption = ConfigOptions.key(ExternalResourceOptions.getSystemConfigKeyConfigOptionForResource(resourceName, suffix)).stringType().noDefaultValue();
            String configKey = config.get(configKeyOption);
            if (StringUtils.isNullOrWhitespaceOnly(configKey)) {
                LOG.warn("Could not find valid {} for {}. Will ignore that resource.", (Object)configKeyOption.key(), (Object)resourceName);
                continue;
            }
            configKeysToResourceNameMap.compute(configKey, (ignored, previousResource) -> {
                if (previousResource != null) {
                    LOG.warn("Duplicate config key {} occurred for external resources, the one named {} will overwrite the value.", (Object)configKey, (Object)resourceName);
                    externalResourceConfigs.remove(previousResource);
                }
                return resourceName;
            });
            externalResourceConfigs.put(resourceName, configKey);
        }
        return externalResourceConfigs;
    }

    public static ExternalResourceInfoProvider createStaticExternalResourceInfoProviderFromConfig(Configuration configuration, PluginManager pluginManager) {
        Map<String, Long> externalResourceAmountMap = ExternalResourceUtils.getExternalResourceAmountMap(configuration);
        LOG.info("Enabled external resources: {}", externalResourceAmountMap.keySet());
        return ExternalResourceUtils.createStaticExternalResourceInfoProvider(externalResourceAmountMap, ExternalResourceUtils.externalResourceDriversFromConfig(configuration, pluginManager));
    }

    @VisibleForTesting
    static Map<String, Long> getExternalResourceAmountMap(Configuration config) {
        Set<String> resourceSet = ExternalResourceUtils.getExternalResourceSet(config);
        if (resourceSet.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> externalResourceAmountMap = new HashMap<String, Long>();
        for (String resourceName : resourceSet) {
            ConfigOption<Long> amountOption = ConfigOptions.key(ExternalResourceOptions.getAmountConfigOptionForResource(resourceName)).longType().noDefaultValue();
            Optional<Long> amountOpt = config.getOptional(amountOption);
            if (!amountOpt.isPresent()) {
                LOG.warn("The amount of the {} should be configured. Will ignore that resource.", (Object)resourceName);
                continue;
            }
            if (amountOpt.get() <= 0L) {
                LOG.warn("The amount of the {} should be positive while finding {}. Will ignore that resource.", (Object)amountOpt.get(), (Object)resourceName);
                continue;
            }
            externalResourceAmountMap.put(resourceName, amountOpt.get());
        }
        return externalResourceAmountMap;
    }

    public static Collection<ExternalResource> getExternalResourcesCollection(Configuration config) {
        return ExternalResourceUtils.getExternalResourceAmountMap(config).entrySet().stream().map(entry -> new ExternalResource((String)entry.getKey(), ((Long)entry.getValue()).longValue())).collect(Collectors.toList());
    }

    public static String generateExternalResourcesString(Collection<ExternalResource> extendedResources) {
        return extendedResources.stream().map(resource -> resource.getName() + "=" + String.valueOf(resource.getValue())).collect(Collectors.joining(", "));
    }

    @VisibleForTesting
    static Map<String, ExternalResourceDriver> externalResourceDriversFromConfig(Configuration config, PluginManager pluginManager) {
        Set<String> resourceSet = ExternalResourceUtils.getExternalResourceSet(config);
        if (resourceSet.isEmpty()) {
            return Collections.emptyMap();
        }
        Iterator<ExternalResourceDriverFactory> factoryIterator = pluginManager.load(ExternalResourceDriverFactory.class);
        HashMap externalResourceFactories = new HashMap();
        factoryIterator.forEachRemaining(externalResourceDriverFactory -> externalResourceFactories.put(externalResourceDriverFactory.getClass().getName(), externalResourceDriverFactory));
        HashMap<String, ExternalResourceDriver> externalResourceDrivers = new HashMap<String, ExternalResourceDriver>();
        for (String resourceName : resourceSet) {
            ConfigOption<String> driverClassOption = ConfigOptions.key(ExternalResourceOptions.getExternalResourceDriverFactoryConfigOptionForResource(resourceName)).stringType().noDefaultValue();
            String driverFactoryClassName = config.get(driverClassOption);
            if (StringUtils.isNullOrWhitespaceOnly(driverFactoryClassName)) {
                LOG.warn("Could not find driver class name for {}. Please make sure {} is configured.", (Object)resourceName, (Object)driverClassOption.key());
                continue;
            }
            ExternalResourceDriverFactory externalResourceDriverFactory2 = (ExternalResourceDriverFactory)externalResourceFactories.get(driverFactoryClassName);
            if (externalResourceDriverFactory2 != null) {
                DelegatingConfiguration delegatingConfiguration = new DelegatingConfiguration(config, ExternalResourceOptions.getExternalResourceParamConfigPrefixForResource(resourceName));
                try {
                    externalResourceDrivers.put(resourceName, externalResourceDriverFactory2.createExternalResourceDriver(delegatingConfiguration));
                    LOG.info("Add external resources driver for {}.", (Object)resourceName);
                }
                catch (Exception e) {
                    LOG.warn("Could not instantiate driver with factory {} for {}. {}", new Object[]{driverFactoryClassName, resourceName, e});
                }
                continue;
            }
            LOG.warn("Could not find factory class {} for {}.", (Object)driverFactoryClassName, (Object)resourceName);
        }
        return externalResourceDrivers;
    }

    @VisibleForTesting
    static ExternalResourceInfoProvider createStaticExternalResourceInfoProvider(Map<String, Long> externalResourceAmountMap, Map<String, ExternalResourceDriver> externalResourceDrivers) {
        HashMap<String, Set<? extends ExternalResourceInfo>> externalResources = new HashMap<String, Set<? extends ExternalResourceInfo>>();
        for (Map.Entry<String, ExternalResourceDriver> externalResourceDriverEntry : externalResourceDrivers.entrySet()) {
            String resourceName = externalResourceDriverEntry.getKey();
            ExternalResourceDriver externalResourceDriver = externalResourceDriverEntry.getValue();
            if (externalResourceAmountMap.containsKey(resourceName)) {
                try {
                    Set<? extends ExternalResourceInfo> externalResourceInfos = externalResourceDriver.retrieveResourceInfo(externalResourceAmountMap.get(resourceName));
                    externalResources.put(resourceName, externalResourceInfos);
                }
                catch (Exception e) {
                    LOG.warn("Failed to retrieve information of external resource {}.", (Object)resourceName, (Object)e);
                }
                continue;
            }
            LOG.warn("Could not found legal amount configuration for {}.", (Object)resourceName);
        }
        return new StaticExternalResourceInfoProvider(externalResources);
    }
}

