/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class TaskInformation
implements Serializable {
    private static final long serialVersionUID = -9006218793155953789L;
    private final JobVertexID jobVertexId;
    private final String taskName;
    private final int numberOfSubtasks;
    private final int maxNumberOfSubtasks;
    private final String invokableClassName;
    private final Configuration taskConfiguration;

    public TaskInformation(JobVertexID jobVertexId, String taskName, int numberOfSubtasks, int maxNumberOfSubtasks, String invokableClassName, Configuration taskConfiguration) {
        this.jobVertexId = Preconditions.checkNotNull(jobVertexId);
        this.taskName = Preconditions.checkNotNull(taskName);
        this.numberOfSubtasks = numberOfSubtasks;
        this.maxNumberOfSubtasks = maxNumberOfSubtasks;
        this.invokableClassName = Preconditions.checkNotNull(invokableClassName);
        this.taskConfiguration = Preconditions.checkNotNull(taskConfiguration);
    }

    public JobVertexID getJobVertexId() {
        return this.jobVertexId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getNumberOfSubtasks() {
        return this.numberOfSubtasks;
    }

    public int getMaxNumberOfSubtasks() {
        return this.maxNumberOfSubtasks;
    }

    public String getInvokableClassName() {
        return this.invokableClassName;
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public TaskInformation deepCopy() {
        return new TaskInformation(this.getJobVertexId(), this.getTaskName(), this.getNumberOfSubtasks(), this.getMaxNumberOfSubtasks(), this.getInvokableClassName(), new Configuration(this.getTaskConfiguration()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInformation that = (TaskInformation)o;
        return this.numberOfSubtasks == that.numberOfSubtasks && this.maxNumberOfSubtasks == that.maxNumberOfSubtasks && Objects.equals(this.jobVertexId, that.jobVertexId) && Objects.equals(this.taskName, that.taskName) && Objects.equals(this.invokableClassName, that.invokableClassName) && Objects.equals(this.taskConfiguration, that.taskConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.jobVertexId, this.taskName, this.numberOfSubtasks, this.maxNumberOfSubtasks, this.invokableClassName, this.taskConfiguration);
    }
}

