/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.ogg;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.formats.json.ogg.OggJsonDecodingFormat;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

@Internal
public final class OggJsonDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final String OP_CREATE = "I";
    private static final String OP_UPDATE = "U";
    private static final String OP_DELETE = "D";
    private static final String OP_TRUNCATE = "T";
    private static final String REPLICA_IDENTITY_EXCEPTION = "The \"before\" field of %s message is null, if you are using Ogg Postgres Connector, please check the Postgres table has been set REPLICA IDENTITY to FULL level.";
    private final JsonRowDataDeserializationSchema jsonDeserializer;
    private final boolean hasMetadata;
    private final MetadataConverter[] metadataConverters;
    private final TypeInformation<RowData> producedTypeInfo;
    private final boolean ignoreParseErrors;
    private transient List<GenericRowData> genericRowDataList;

    public OggJsonDeserializationSchema(DataType physicalDataType, List<OggJsonDecodingFormat.ReadableMetadata> requestedMetadata, TypeInformation<RowData> producedTypeInfo, boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        RowType jsonRowType = OggJsonDeserializationSchema.createJsonRowType(physicalDataType, requestedMetadata);
        this.jsonDeserializer = new JsonRowDataDeserializationSchema(jsonRowType, producedTypeInfo, false, ignoreParseErrors, timestampFormat);
        this.hasMetadata = requestedMetadata.size() > 0;
        this.metadataConverters = OggJsonDeserializationSchema.createMetadataConverters(jsonRowType, requestedMetadata);
        this.producedTypeInfo = producedTypeInfo;
        this.ignoreParseErrors = ignoreParseErrors;
    }

    private static RowType createJsonRowType(DataType physicalDataType, List<OggJsonDecodingFormat.ReadableMetadata> readableMetadata) {
        DataType root = DataTypes.ROW(DataTypes.FIELD("before", physicalDataType), DataTypes.FIELD("after", physicalDataType), DataTypes.FIELD("op_type", DataTypes.STRING()));
        List<DataTypes.Field> rootMetadataFields = readableMetadata.stream().map(m -> m.requiredJsonField).distinct().collect(Collectors.toList());
        return (RowType)DataTypeUtils.appendRowFields(root, rootMetadataFields).getLogicalType();
    }

    private static MetadataConverter[] createMetadataConverters(RowType jsonRowType, List<OggJsonDecodingFormat.ReadableMetadata> requestedMetadata) {
        return (MetadataConverter[])requestedMetadata.stream().map(m -> OggJsonDeserializationSchema.convertInRoot(jsonRowType, m)).toArray(MetadataConverter[]::new);
    }

    private static MetadataConverter convertInRoot(RowType jsonRowType, final OggJsonDecodingFormat.ReadableMetadata metadata) {
        final int pos = OggJsonDeserializationSchema.findFieldPos(metadata, jsonRowType);
        return new MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData root, int unused) {
                return metadata.converter.convert(root, pos);
            }
        };
    }

    private static int findFieldPos(OggJsonDecodingFormat.ReadableMetadata metadata, RowType jsonRowType) {
        return jsonRowType.getFieldNames().indexOf(metadata.requiredJsonField.getName());
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.genericRowDataList = new ArrayList<GenericRowData>();
        this.jsonDeserializer.open(context);
    }

    @Override
    public RowData deserialize(byte[] message) {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    @Override
    public void deserialize(byte[] message, Collector<RowData> out) throws IOException {
        block13: {
            if (message == null || message.length == 0) {
                return;
            }
            this.genericRowDataList.clear();
            try {
                GenericRowData row = (GenericRowData)this.jsonDeserializer.deserialize(message);
                GenericRowData before = (GenericRowData)row.getField(0);
                GenericRowData after = (GenericRowData)row.getField(1);
                String op = row.getField(2).toString();
                if (OP_CREATE.equals(op)) {
                    after.setRowKind(RowKind.INSERT);
                    this.genericRowDataList.add(this.emitRow(row, after));
                } else if (OP_UPDATE.equals(op)) {
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                    }
                    before.setRowKind(RowKind.UPDATE_BEFORE);
                    after.setRowKind(RowKind.UPDATE_AFTER);
                    this.genericRowDataList.add(this.emitRow(row, before));
                    this.genericRowDataList.add(this.emitRow(row, after));
                } else if (OP_DELETE.equals(op)) {
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "DELETE"));
                    }
                    before.setRowKind(RowKind.DELETE);
                    this.genericRowDataList.add(this.emitRow(row, before));
                } else if (!this.ignoreParseErrors) {
                    throw new IOException(String.format("Unknown \"op_type\" value \"%s\". The Ogg JSON message is '%s'", op, new String(message)));
                }
            }
            catch (Throwable t) {
                if (this.ignoreParseErrors) break block13;
                throw new IOException(String.format("Corrupt Ogg JSON message '%s'.", new String(message)), t);
            }
        }
        for (GenericRowData genericRowData : this.genericRowDataList) {
            out.collect(genericRowData);
        }
    }

    private GenericRowData emitRow(GenericRowData rootRow, GenericRowData physicalRow) {
        if (!this.hasMetadata) {
            return physicalRow;
        }
        int physicalArity = physicalRow.getArity();
        int metadataArity = this.metadataConverters.length;
        GenericRowData producedRow = new GenericRowData(physicalRow.getRowKind(), physicalArity + metadataArity);
        for (int physicalPos = 0; physicalPos < physicalArity; ++physicalPos) {
            producedRow.setField(physicalPos, physicalRow.getField(physicalPos));
        }
        for (int metadataPos = 0; metadataPos < metadataArity; ++metadataPos) {
            producedRow.setField(physicalArity + metadataPos, this.metadataConverters[metadataPos].convert(rootRow));
        }
        return producedRow;
    }

    @Override
    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    @Override
    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OggJsonDeserializationSchema that = (OggJsonDeserializationSchema)o;
        return Objects.equals(this.jsonDeserializer, that.jsonDeserializer) && this.hasMetadata == that.hasMetadata && Objects.equals(this.producedTypeInfo, that.producedTypeInfo) && this.ignoreParseErrors == that.ignoreParseErrors;
    }

    public int hashCode() {
        return Objects.hash(this.jsonDeserializer, this.hasMetadata, this.producedTypeInfo, this.ignoreParseErrors);
    }

    static interface MetadataConverter
    extends Serializable {
        default public Object convert(GenericRowData row) {
            return this.convert(row, -1);
        }

        public Object convert(GenericRowData var1, int var2);
    }
}

