/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.canal;

import java.util.Objects;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.JsonRowDataSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;

public class CanalJsonSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final StringData OP_INSERT = StringData.fromString("INSERT");
    private static final StringData OP_DELETE = StringData.fromString("DELETE");
    private transient GenericRowData reuse;
    private final JsonRowDataSerializationSchema jsonSerializer;

    public CanalJsonSerializationSchema(RowType rowType, TimestampFormat timestampFormat, JsonFormatOptions.MapNullKeyMode mapNullKeyMode, String mapNullKeyLiteral, boolean encodeDecimalAsPlainNumber, boolean ignoreNullFields) {
        this.jsonSerializer = new JsonRowDataSerializationSchema(CanalJsonSerializationSchema.createJsonRowType(TypeConversions.fromLogicalToDataType(rowType)), timestampFormat, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber, ignoreNullFields);
    }

    @Override
    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.jsonSerializer.open(context);
        this.reuse = new GenericRowData(2);
    }

    @Override
    public byte[] serialize(RowData row) {
        try {
            StringData opType = this.rowKind2String(row.getRowKind());
            GenericArrayData arrayData = new GenericArrayData(new RowData[]{row});
            this.reuse.setField(0, arrayData);
            this.reuse.setField(1, opType);
            return this.jsonSerializer.serialize(this.reuse);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize row '" + String.valueOf(row) + "'.", t);
        }
    }

    private StringData rowKind2String(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: 
            case UPDATE_AFTER: {
                return OP_INSERT;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                return OP_DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported operation '" + String.valueOf((Object)rowKind) + "' for row kind.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanalJsonSerializationSchema that = (CanalJsonSerializationSchema)o;
        return Objects.equals(this.jsonSerializer, that.jsonSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.jsonSerializer);
    }

    private static RowType createJsonRowType(DataType databaseSchema) {
        return (RowType)DataTypes.ROW(DataTypes.FIELD("data", DataTypes.ARRAY(databaseSchema)), DataTypes.FIELD("type", DataTypes.STRING())).getLogicalType();
    }
}

