/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import org.apache.flink.annotation.Public;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.LocatableInputSplit;

@Public
public class FileInputSplit
extends LocatableInputSplit {
    private static final long serialVersionUID = 1L;
    private final Path file;
    private final long start;
    private final long length;

    public FileInputSplit(int num, Path file, long start, long length, String[] hosts) {
        super(num, hosts);
        this.file = file;
        this.start = start;
        this.length = length;
    }

    public Path getPath() {
        return this.file;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public int hashCode() {
        return this.getSplitNumber() ^ (this.file == null ? 0 : this.file.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileInputSplit && super.equals(obj)) {
            FileInputSplit other = (FileInputSplit)obj;
            return this.start == other.start && this.length == other.length && (this.file == null ? other.file == null : other.file != null && this.file.equals(other.file));
        }
        return false;
    }

    @Override
    public String toString() {
        return "[" + this.getSplitNumber() + "] " + String.valueOf(this.file) + ":" + this.start + "+" + this.length;
    }
}

