/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.connector.source.SourceSplit;

@Public
public final class ReaderInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int subtaskId;
    private final String location;
    private final List<SourceSplit> reportedSplitsOnRegistration;

    public ReaderInfo(int subtaskId, String location) {
        this(subtaskId, location, Collections.emptyList());
    }

    ReaderInfo(int subtaskId, String location, List<SourceSplit> splits) {
        this.subtaskId = subtaskId;
        this.location = location;
        this.reportedSplitsOnRegistration = splits;
    }

    public static <SplitT extends SourceSplit> ReaderInfo createReaderInfo(int subtaskId, String location, List<SplitT> splits) {
        return new ReaderInfo(subtaskId, location, splits);
    }

    public <SplitT extends SourceSplit> List<SplitT> getReportedSplitsOnRegistration() {
        return this.reportedSplitsOnRegistration;
    }

    public int getSubtaskId() {
        return this.subtaskId;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReaderInfo)) {
            return false;
        }
        ReaderInfo that = (ReaderInfo)o;
        return this.subtaskId == that.subtaskId && Objects.equals(this.location, that.location) && Objects.equals(this.reportedSplitsOnRegistration, that.reportedSplitsOnRegistration);
    }

    public int hashCode() {
        return Objects.hash(this.subtaskId, this.location, this.reportedSplitsOnRegistration);
    }
}

