/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.serialization;

import com.esotericsoftware.kryo.Serializer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.SerializableSerializer;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInfoFactory;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;

@Internal
public final class SerializerConfigImpl
implements SerializerConfig {
    private static final long serialVersionUID = 1L;
    private final Configuration configuration;
    private LinkedHashMap<Class<?>, SerializableSerializer<?>> registeredTypesWithKryoSerializers = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> registeredTypesWithKryoSerializerClasses = new LinkedHashMap();
    private LinkedHashMap<Class<?>, SerializableSerializer<?>> defaultKryoSerializers = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses = new LinkedHashMap();
    private LinkedHashSet<Class<?>> registeredKryoTypes = new LinkedHashSet();
    private LinkedHashSet<Class<?>> registeredPojoTypes = new LinkedHashSet();
    private Map<Class<?>, Class<? extends TypeInfoFactory<?>>> registeredTypeInfoFactories = new HashMap();

    public SerializerConfigImpl() {
        Configuration conf;
        this.configuration = conf = new Configuration();
    }

    @Internal
    public SerializerConfigImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    public <T extends Serializer<?>> void addDefaultKryoSerializer(Class<?> type, T serializer) {
        if (type == null || serializer == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.defaultKryoSerializers.put(type, new SerializableSerializer<T>(serializer));
    }

    public void addDefaultKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        if (type == null || serializerClass == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.defaultKryoSerializerClasses.put(type, serializerClass);
    }

    public <T extends Serializer<?>> void registerTypeWithKryoSerializer(Class<?> type, T serializer) {
        if (type == null || serializer == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.registeredTypesWithKryoSerializers.put(type, new SerializableSerializer<T>(serializer));
    }

    public void registerTypeWithKryoSerializer(Class<?> type, Class<? extends Serializer> serializerClass) {
        if (type == null || serializerClass == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        Class<? extends Serializer> castedSerializerClass = serializerClass;
        this.registeredTypesWithKryoSerializerClasses.put(type, castedSerializerClass);
    }

    public void registerPojoType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        this.registeredPojoTypes.add(type);
    }

    public void registerKryoType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        this.registeredKryoTypes.add(type);
    }

    public LinkedHashMap<Class<?>, SerializableSerializer<?>> getRegisteredTypesWithKryoSerializers() {
        return this.registeredTypesWithKryoSerializers;
    }

    @Override
    public LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> getRegisteredTypesWithKryoSerializerClasses() {
        return this.registeredTypesWithKryoSerializerClasses;
    }

    public LinkedHashMap<Class<?>, SerializableSerializer<?>> getDefaultKryoSerializers() {
        return this.defaultKryoSerializers;
    }

    @Override
    public LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> getDefaultKryoSerializerClasses() {
        return this.defaultKryoSerializerClasses;
    }

    @Override
    public LinkedHashSet<Class<?>> getRegisteredKryoTypes() {
        if (this.isForceKryoEnabled()) {
            LinkedHashSet result = new LinkedHashSet(this.registeredKryoTypes);
            result.addAll(this.registeredPojoTypes);
            return result;
        }
        return this.registeredKryoTypes;
    }

    @Override
    public LinkedHashSet<Class<?>> getRegisteredPojoTypes() {
        return this.registeredPojoTypes;
    }

    @Override
    public Map<Class<?>, Class<? extends TypeInfoFactory<?>>> getRegisteredTypeInfoFactories() {
        return this.registeredTypeInfoFactories;
    }

    @Override
    public boolean hasGenericTypesDisabled() {
        return this.configuration.get(PipelineOptions.GENERIC_TYPES) == false;
    }

    public void setGenericTypes(boolean genericTypes) {
        this.configuration.set((ConfigOption)PipelineOptions.GENERIC_TYPES, (Object)genericTypes);
    }

    @Override
    public boolean isForceKryoEnabled() {
        return this.configuration.get(PipelineOptions.FORCE_KRYO);
    }

    public void setForceKryo(boolean forceKryo) {
        this.configuration.set((ConfigOption)PipelineOptions.FORCE_KRYO, (Object)forceKryo);
    }

    @Override
    public boolean isForceAvroEnabled() {
        return this.configuration.get(PipelineOptions.FORCE_AVRO);
    }

    public void setForceAvro(boolean forceAvro) {
        this.configuration.set((ConfigOption)PipelineOptions.FORCE_AVRO, (Object)forceAvro);
    }

    public void setForceKryoAvro(boolean forceKryoAvro) {
        this.configuration.set((ConfigOption)PipelineOptions.FORCE_KRYO_AVRO, (Object)forceKryoAvro);
    }

    @Override
    public TernaryBoolean isForceKryoAvroEnabled() {
        return this.configuration.getOptional(PipelineOptions.FORCE_KRYO_AVRO).map(TernaryBoolean::fromBoolean).orElse(TernaryBoolean.UNDEFINED);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerializerConfigImpl) {
            SerializerConfigImpl other = (SerializerConfigImpl)obj;
            return Objects.equals(this.configuration, other.configuration) && this.registeredTypesWithKryoSerializers.equals(other.registeredTypesWithKryoSerializers) && this.registeredTypesWithKryoSerializerClasses.equals(other.registeredTypesWithKryoSerializerClasses) && this.defaultKryoSerializers.equals(other.defaultKryoSerializers) && this.defaultKryoSerializerClasses.equals(other.defaultKryoSerializerClasses) && this.registeredKryoTypes.equals(other.registeredKryoTypes) && this.registeredPojoTypes.equals(other.registeredPojoTypes) && this.registeredTypeInfoFactories.equals(other.registeredTypeInfoFactories);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.registeredTypesWithKryoSerializers, this.registeredTypesWithKryoSerializerClasses, this.defaultKryoSerializers, this.defaultKryoSerializerClasses, this.registeredKryoTypes, this.registeredPojoTypes, this.registeredTypeInfoFactories);
    }

    public String toString() {
        return "SerializerConfig{configuration=" + String.valueOf(this.configuration) + ", registeredTypesWithKryoSerializers=" + String.valueOf(this.registeredTypesWithKryoSerializers) + ", registeredTypesWithKryoSerializerClasses=" + String.valueOf(this.registeredTypesWithKryoSerializerClasses) + ", defaultKryoSerializers=" + String.valueOf(this.defaultKryoSerializers) + ", defaultKryoSerializerClasses=" + String.valueOf(this.defaultKryoSerializerClasses) + ", registeredKryoTypes=" + String.valueOf(this.registeredKryoTypes) + ", registeredPojoTypes=" + String.valueOf(this.registeredPojoTypes) + ", registeredTypeFactories=" + String.valueOf(this.registeredTypeInfoFactories) + "}";
    }

    @Override
    public void configure(ReadableConfig configuration, ClassLoader classLoader) {
        configuration.getOptional(PipelineOptions.GENERIC_TYPES).ifPresent(this::setGenericTypes);
        configuration.getOptional(PipelineOptions.FORCE_KRYO).ifPresent(this::setForceKryo);
        configuration.getOptional(PipelineOptions.FORCE_AVRO).ifPresent(this::setForceAvro);
        configuration.getOptional(PipelineOptions.FORCE_KRYO_AVRO).ifPresent(this::setForceKryoAvro);
        configuration.getOptional(PipelineOptions.SERIALIZATION_CONFIG).ifPresent(c -> this.parseSerializationConfigWithExceptionHandling(classLoader, (List<String>)c));
    }

    private <T extends Class> T loadClass(String className, ClassLoader classLoader, String errorMessage) {
        try {
            return (T)Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(errorMessage, e);
        }
    }

    private void parseSerializationConfigWithExceptionHandling(ClassLoader classLoader, List<String> serializationConfigs) {
        try {
            this.parseSerializationConfig(classLoader, serializationConfigs);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not configure serializers from %s.", serializationConfigs), e);
        }
    }

    private void parseSerializationConfig(ClassLoader classLoader, List<String> serializationConfigs) {
        LinkedHashMap serializationConfigByClass = serializationConfigs.stream().map(ConfigurationUtils::parseStringToMap).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(e -> this.loadClass((String)e.getKey(), classLoader, "Could not load class for serialization config"), e -> ConfigurationUtils.parseStringToMap((String)e.getValue()), (v1, v2) -> {
            throw new IllegalArgumentException("Duplicated serializer for the same class.");
        }, LinkedHashMap::new));
        block10: for (Map.Entry entry : serializationConfigByClass.entrySet()) {
            Class type = (Class)entry.getKey();
            Map config = (Map)entry.getValue();
            String configType = (String)config.get("type");
            if (configType == null) {
                throw new IllegalArgumentException("Serializer type not specified for " + String.valueOf(type));
            }
            switch (configType) {
                case "pojo": {
                    this.registerPojoType(type);
                    continue block10;
                }
                case "kryo": {
                    this.parseAndRegisterKryoType(classLoader, type, config);
                    continue block10;
                }
                case "typeinfo": {
                    this.parseAndRegisterTypeFactory(classLoader, type, config);
                    continue block10;
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported serializer type %s for %s", configType, type));
        }
    }

    private void parseAndRegisterKryoType(ClassLoader classLoader, Class<?> t, Map<String, String> m) {
        String kryoType = m.get("kryo-type");
        if (kryoType == null) {
            this.registerKryoType(t);
        } else {
            switch (kryoType) {
                case "default": {
                    this.addDefaultKryoSerializer(t, (Class<? extends Serializer<?>>)this.loadClass(m.get("class"), classLoader, "Could not load serializer's class"));
                    break;
                }
                case "registered": {
                    this.registerTypeWithKryoSerializer(t, (Class<? extends Serializer>)this.loadClass(m.get("class"), classLoader, "Could not load serializer's class"));
                    break;
                }
            }
        }
    }

    private void parseAndRegisterTypeFactory(ClassLoader classLoader, Class<?> t, Map<String, String> m) {
        Object factoryClass = this.loadClass(m.get("class"), classLoader, "Could not load TypeInfoFactory's class");
        TypeExtractor.registerFactory(t, factoryClass);
        this.registerTypeWithTypeInfoFactory(t, (Class<? extends TypeInfoFactory<?>>)factoryClass);
    }

    private void registerTypeWithTypeInfoFactory(Class<?> t, Class<? extends TypeInfoFactory<?>> factory) {
        Preconditions.checkNotNull(t, "Type parameter must not be null.");
        Preconditions.checkNotNull(factory, "Factory parameter must not be null.");
        if (!TypeInfoFactory.class.isAssignableFrom(factory)) {
            throw new IllegalArgumentException("Class is not a TypeInfoFactory.");
        }
        if (this.registeredTypeInfoFactories.containsKey(t)) {
            throw new InvalidTypesException("A TypeInfoFactory for type '" + String.valueOf(t) + "' is already registered.");
        }
        this.registeredTypeInfoFactories.put(t, factory);
    }

    @Override
    public SerializerConfigImpl copy() {
        SerializerConfigImpl newSerializerConfig = new SerializerConfigImpl();
        newSerializerConfig.configure(this.configuration, this.getClass().getClassLoader());
        this.getRegisteredTypesWithKryoSerializers().forEach((c, s) -> newSerializerConfig.registerTypeWithKryoSerializer((Class<?>)c, s.getSerializer()));
        this.getRegisteredTypesWithKryoSerializerClasses().forEach(newSerializerConfig::registerTypeWithKryoSerializer);
        this.getDefaultKryoSerializers().forEach((c, s) -> newSerializerConfig.addDefaultKryoSerializer((Class<?>)c, s.getSerializer()));
        this.getDefaultKryoSerializerClasses().forEach(newSerializerConfig::addDefaultKryoSerializer);
        this.getRegisteredKryoTypes().forEach(newSerializerConfig::registerKryoType);
        this.getRegisteredPojoTypes().forEach(newSerializerConfig::registerPojoType);
        this.getRegisteredTypeInfoFactories().forEach(newSerializerConfig::registerTypeWithTypeInfoFactory);
        return newSerializerConfig;
    }
}

