/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.lang.reflect.Constructor;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongComparator;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeQueryable;
import org.apache.flink.util.Preconditions;

@Internal
@Deprecated
public final class TimeIntervalTypeInfo<T>
extends TypeInformation<T>
implements AtomicType<T>,
DataTypeQueryable {
    private static final long serialVersionUID = -1816179424364825258L;
    public static final TimeIntervalTypeInfo<Integer> INTERVAL_MONTHS = new TimeIntervalTypeInfo<Integer>(Integer.class, IntSerializer.INSTANCE, IntComparator.class);
    public static final TimeIntervalTypeInfo<Long> INTERVAL_MILLIS = new TimeIntervalTypeInfo<Long>(Long.class, LongSerializer.INSTANCE, LongComparator.class);
    private final Class<T> clazz;
    private final TypeSerializer<T> serializer;
    private final Class<? extends TypeComparator<T>> comparatorClass;

    private TimeIntervalTypeInfo(Class<T> clazz, TypeSerializer<T> serializer, Class<? extends TypeComparator<T>> comparatorClass) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.serializer = Preconditions.checkNotNull(serializer);
        this.comparatorClass = Preconditions.checkNotNull(comparatorClass);
    }

    @Override
    public DataType getDataType() {
        if (this.clazz == Long.class) {
            return (DataType)DataTypes.INTERVAL(DataTypes.SECOND(3)).bridgedTo(Long.class);
        }
        if (this.clazz == Integer.class) {
            return (DataType)DataTypes.INTERVAL(DataTypes.MONTH()).bridgedTo(Integer.class);
        }
        throw new UnsupportedOperationException("Unsupported interval type info.");
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.clazz;
    }

    @Override
    public boolean isKeyType() {
        return true;
    }

    @Override
    public TypeSerializer<T> createSerializer(SerializerConfig config) {
        return this.serializer;
    }

    @Override
    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        try {
            Constructor<TypeComparator<T>> constructor = this.comparatorClass.getConstructor(Boolean.TYPE);
            return constructor.newInstance(sortOrderAscending);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize comparator " + this.comparatorClass.getName(), e);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clazz, this.serializer, this.comparatorClass);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof TimeIntervalTypeInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TimeIntervalTypeInfo) {
            TimeIntervalTypeInfo other = (TimeIntervalTypeInfo)obj;
            return other.canEqual(this) && this.clazz.equals(other.clazz) && this.serializer == other.serializer && this.comparatorClass.equals(other.comparatorClass);
        }
        return false;
    }

    @Override
    public String toString() {
        return TimeIntervalTypeInfo.class.getSimpleName() + "(" + this.clazz.getSimpleName() + ")";
    }
}

