/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks.mailbox;

import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.streaming.runtime.tasks.StreamTaskActionExecutor;
import org.apache.flink.streaming.runtime.tasks.mailbox.Mail;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxProcessor;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailbox;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.WrappingRuntimeException;
import org.apache.flink.util.function.ThrowingRunnable;

@Internal
public final class MailboxExecutorImpl
implements MailboxExecutor {
    @Nonnull
    private final TaskMailbox mailbox;
    private final int priority;
    private final StreamTaskActionExecutor actionExecutor;
    private final MailboxProcessor mailboxProcessor;

    public MailboxExecutorImpl(@Nonnull TaskMailbox mailbox, int priority, StreamTaskActionExecutor actionExecutor) {
        this(mailbox, priority, actionExecutor, null);
    }

    public MailboxExecutorImpl(@Nonnull TaskMailbox mailbox, int priority, StreamTaskActionExecutor actionExecutor, MailboxProcessor mailboxProcessor) {
        this.mailbox = mailbox;
        this.priority = priority;
        this.actionExecutor = Preconditions.checkNotNull(actionExecutor);
        this.mailboxProcessor = mailboxProcessor;
    }

    public boolean isIdle() {
        return !this.mailboxProcessor.isDefaultActionAvailable() && !this.mailbox.hasMail() && this.mailbox.getState().isAcceptingMails();
    }

    @Override
    public void execute(MailboxExecutor.MailOptions mailOptions, ThrowingRunnable<? extends Exception> command, String descriptionFormat, Object ... descriptionArgs) {
        try {
            this.mailbox.put(new Mail(mailOptions, command, this.priority, this.actionExecutor, descriptionFormat, descriptionArgs));
        }
        catch (TaskMailbox.MailboxClosedException mbex) {
            throw new RejectedExecutionException(mbex);
        }
    }

    @Override
    public void yield() throws InterruptedException {
        Mail mail = this.mailbox.take(this.priority);
        try {
            mail.run();
        }
        catch (Exception ex) {
            throw WrappingRuntimeException.wrapIfNecessary(ex);
        }
    }

    @Override
    public boolean tryYield() {
        Optional<Mail> optionalMail = this.mailbox.tryTake(this.priority);
        if (optionalMail.isPresent()) {
            try {
                optionalMail.get().run();
            }
            catch (Exception ex) {
                throw WrappingRuntimeException.wrapIfNecessary(ex);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldInterrupt() {
        return this.mailbox.hasMail();
    }

    @VisibleForTesting
    public int getPriority() {
        return this.priority;
    }
}

