/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sorted.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.runtime.state.PriorityComparator;
import org.apache.flink.runtime.state.heap.HeapPriorityQueue;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;

class BatchExecutionInternalPriorityQueueSet<T extends HeapPriorityQueueElement>
extends HeapPriorityQueue<T>
implements KeyGroupedInternalPriorityQueue<T> {
    private final Map<T, T> dedupMap = new HashMap<T, T>();

    BatchExecutionInternalPriorityQueueSet(@Nonnull PriorityComparator<T> elementPriorityComparator, int minimumCapacity) {
        super(elementPriorityComparator, minimumCapacity);
    }

    @Override
    @Nonnull
    public Set<T> getSubsetForKeyGroup(int keyGroupId) {
        throw new UnsupportedOperationException("Getting subset for key group is not supported in BATCH runtime mode.");
    }

    @Override
    @Nullable
    public T poll() {
        Object toRemove = super.poll();
        return (T)(toRemove != null ? (HeapPriorityQueueElement)this.dedupMap.remove(toRemove) : null);
    }

    @Override
    public boolean add(@Nonnull T element) {
        return this.dedupMap.putIfAbsent(element, element) == null && super.add(element);
    }

    @Override
    public boolean remove(@Nonnull T toRemove) {
        HeapPriorityQueueElement storedElement = (HeapPriorityQueueElement)this.dedupMap.remove(toRemove);
        return storedElement != null && super.remove(storedElement);
    }

    @Override
    public void clear() {
        super.clear();
        this.dedupMap.clear();
    }
}

