/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.rest.handler.async.OperationKey;
import org.apache.flink.runtime.rest.messages.TriggerId;

@Immutable
public class AsynchronousJobOperationKey
extends OperationKey {
    private static final long serialVersionUID = -4907777251835275859L;
    private final JobID jobId;

    private AsynchronousJobOperationKey(TriggerId triggerId, JobID jobId) {
        super(triggerId);
        this.jobId = Objects.requireNonNull(jobId);
    }

    public static AsynchronousJobOperationKey of(TriggerId triggerId, JobID jobId) {
        return new AsynchronousJobOperationKey(triggerId, jobId);
    }

    public JobID getJobId() {
        return this.jobId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AsynchronousJobOperationKey that = (AsynchronousJobOperationKey)o;
        return Objects.equals(this.jobId, that.jobId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.jobId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{triggerId=" + String.valueOf(this.getTriggerId()) + ", jobId=" + String.valueOf(this.jobId) + "}";
    }
}

