/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.active;

import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blocklist.BlockedNodeRetriever;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.resourcemanager.active.ResourceEventHandler;
import org.apache.flink.runtime.resourcemanager.active.ResourceManagerDriver;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceManagerDriver<WorkerType extends ResourceIDRetrievable>
implements ResourceManagerDriver<WorkerType> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Configuration flinkConfig;
    protected final Configuration flinkClientConfig;
    private ResourceEventHandler<WorkerType> resourceEventHandler = null;
    private ScheduledExecutor mainThreadExecutor = null;
    private Executor ioExecutor = null;
    private BlockedNodeRetriever blockedNodeRetriever = null;

    public AbstractResourceManagerDriver(Configuration flinkConfig, Configuration flinkClientConfig) {
        this.flinkConfig = Preconditions.checkNotNull(flinkConfig);
        this.flinkClientConfig = Preconditions.checkNotNull(flinkClientConfig);
    }

    protected final ResourceEventHandler<WorkerType> getResourceEventHandler() {
        Preconditions.checkState(this.resourceEventHandler != null, "Cannot get resource event handler. Resource manager driver is not initialized.");
        return this.resourceEventHandler;
    }

    protected final ScheduledExecutor getMainThreadExecutor() {
        Preconditions.checkState(this.mainThreadExecutor != null, "Cannot get main thread executor. Resource manager driver is not initialized.");
        return this.mainThreadExecutor;
    }

    protected final Executor getIoExecutor() {
        Preconditions.checkState(this.ioExecutor != null, "Cannot get the io executor. Resource manager driver is not initialized.");
        return this.ioExecutor;
    }

    protected final BlockedNodeRetriever getBlockedNodeRetriever() {
        Preconditions.checkState(this.blockedNodeRetriever != null, "Cannot get the blocked node retriever. Resource manager driver is not initialized.");
        return this.blockedNodeRetriever;
    }

    @Override
    public final void initialize(ResourceEventHandler<WorkerType> resourceEventHandler, ScheduledExecutor mainThreadExecutor, Executor ioExecutor, BlockedNodeRetriever blockedNodeRetriever) throws Exception {
        this.resourceEventHandler = Preconditions.checkNotNull(resourceEventHandler);
        this.mainThreadExecutor = Preconditions.checkNotNull(mainThreadExecutor);
        this.ioExecutor = Preconditions.checkNotNull(ioExecutor);
        this.blockedNodeRetriever = Preconditions.checkNotNull(blockedNodeRetriever);
        this.initializeInternal();
    }

    protected abstract void initializeInternal() throws Exception;
}

