/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public class PartitionedFile {
    public static final String DATA_FILE_SUFFIX = ".shuffle.data";
    public static final String INDEX_FILE_SUFFIX = ".shuffle.index";
    public static final int INDEX_ENTRY_SIZE = 16;
    private final int numRegions;
    private final int numSubpartitions;
    private final Path dataFilePath;
    private final Path indexFilePath;
    private final long dataFileSize;
    private final long indexFileSize;
    private final long numBuffers;
    @Nullable
    private final ByteBuffer indexEntryCache;

    public PartitionedFile(int numRegions, int numSubpartitions, Path dataFilePath, Path indexFilePath, long dataFileSize, long indexFileSize, long numBuffers, @Nullable ByteBuffer indexEntryCache) {
        Preconditions.checkArgument(numRegions >= 0, "Illegal number of data regions.");
        Preconditions.checkArgument(numSubpartitions > 0, "Illegal number of subpartitions.");
        this.numRegions = numRegions;
        this.numSubpartitions = numSubpartitions;
        this.dataFilePath = Preconditions.checkNotNull(dataFilePath);
        this.indexFilePath = Preconditions.checkNotNull(indexFilePath);
        this.dataFileSize = dataFileSize;
        this.indexFileSize = indexFileSize;
        this.numBuffers = numBuffers;
        this.indexEntryCache = indexEntryCache;
    }

    public Path getDataFilePath() {
        return this.dataFilePath;
    }

    public Path getIndexFilePath() {
        return this.indexFilePath;
    }

    public int getNumRegions() {
        return this.numRegions;
    }

    public boolean isReadable() {
        return Files.isReadable(this.dataFilePath) && Files.isReadable(this.indexFilePath);
    }

    private long getIndexEntryOffset(int region, int subpartition) {
        Preconditions.checkArgument(region >= 0 && region < this.getNumRegions(), "Illegal target region.");
        Preconditions.checkArgument(subpartition >= 0 && subpartition < this.numSubpartitions, "Subpartition index out of bound.");
        return ((long)region * (long)this.numSubpartitions + (long)subpartition) * 16L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getIndexEntry(FileChannel indexFile, ByteBuffer target, int region, int subpartition) throws IOException {
        Preconditions.checkArgument(target.capacity() == 16, "Illegal target buffer size.");
        target.clear();
        long indexEntryOffset = this.getIndexEntryOffset(region, subpartition);
        if (this.indexEntryCache != null) {
            for (int i = 0; i < 16; ++i) {
                target.put(this.indexEntryCache.get((int)indexEntryOffset + i));
            }
        } else {
            Path path = this.indexFilePath;
            synchronized (path) {
                indexFile.position(indexEntryOffset);
                BufferReaderWriterUtil.readByteBufferFully(indexFile, target);
            }
        }
        target.flip();
    }

    public void deleteQuietly() {
        IOUtils.deleteFileQuietly(this.dataFilePath);
        IOUtils.deleteFileQuietly(this.indexFilePath);
    }

    public String toString() {
        return "PartitionedFile{numRegions=" + this.numRegions + ", numSubpartitions=" + this.numSubpartitions + ", dataFilePath=" + String.valueOf(this.dataFilePath) + ", indexFilePath=" + String.valueOf(this.indexFilePath) + ", dataFileSize=" + this.dataFileSize + ", indexFileSize=" + this.indexFileSize + ", numBuffers=" + this.numBuffers + ", indexDataCached=" + (this.indexEntryCache != null) + "}";
    }
}

