/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.net.InetAddress;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.util.PortRange;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConfig {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConfig.class);
    static final String SERVER_THREAD_GROUP_NAME = "Flink Netty Server";
    static final String CLIENT_THREAD_GROUP_NAME = "Flink Netty Client";
    private final InetAddress serverAddress;
    private final PortRange serverPortRange;
    private final int memorySegmentSize;
    private final int numberOfSlots;
    private final Configuration config;

    public NettyConfig(InetAddress serverAddress, int serverPort, int memorySegmentSize, int numberOfSlots, Configuration config) {
        this(serverAddress, new PortRange(serverPort), memorySegmentSize, numberOfSlots, config);
    }

    public NettyConfig(InetAddress serverAddress, PortRange serverPortRange, int memorySegmentSize, int numberOfSlots, Configuration config) {
        this.serverAddress = Preconditions.checkNotNull(serverAddress);
        this.serverPortRange = serverPortRange;
        Preconditions.checkArgument(memorySegmentSize > 0, "Invalid memory segment size.");
        this.memorySegmentSize = memorySegmentSize;
        Preconditions.checkArgument(numberOfSlots > 0, "Number of slots");
        this.numberOfSlots = numberOfSlots;
        this.config = Preconditions.checkNotNull(config);
        LOG.info(this.toString());
    }

    InetAddress getServerAddress() {
        return this.serverAddress;
    }

    PortRange getServerPortRange() {
        return this.serverPortRange;
    }

    public int getServerConnectBacklog() {
        return 0;
    }

    public int getNumberOfArenas() {
        return this.numberOfSlots;
    }

    public int getServerNumThreads() {
        return this.numberOfSlots;
    }

    public int getClientNumThreads() {
        return this.numberOfSlots;
    }

    public int getClientConnectTimeoutSeconds() {
        return this.config.get(NettyShuffleEnvironmentOptions.CLIENT_CONNECT_TIMEOUT_SECONDS);
    }

    public int getNetworkRetries() {
        return this.config.get(NettyShuffleEnvironmentOptions.NETWORK_RETRIES);
    }

    public int getSendAndReceiveBufferSize() {
        return 0;
    }

    public Optional<Integer> getTcpKeepIdleInSeconds() {
        return this.config.getOptional(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_IDLE_SECONDS);
    }

    public Optional<Integer> getTcpKeepInternalInSeconds() {
        return this.config.getOptional(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_INTERVAL_SECONDS);
    }

    public Optional<Integer> getTcpKeepCount() {
        return this.config.getOptional(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_COUNT);
    }

    @Nullable
    public SSLHandlerFactory createClientSSLEngineFactory() throws Exception {
        return this.getSSLEnabled() ? SSLUtils.createInternalClientSSLEngineFactory(this.config) : null;
    }

    @Nullable
    public SSLHandlerFactory createServerSSLEngineFactory() throws Exception {
        return this.getSSLEnabled() ? SSLUtils.createInternalServerSSLEngineFactory(this.config) : null;
    }

    public boolean getSSLEnabled() {
        return this.config.get(NettyShuffleEnvironmentOptions.DATA_SSL_ENABLED) != false && SecurityOptions.isInternalSSLEnabled(this.config);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String toString() {
        String format = "NettyConfig [server address: %s, server port range: %s, ssl enabled: %s, memory segment size (bytes): %d, number of server threads: %d (%s), number of client threads: %d (%s), server connect backlog: %d (%s), client connect timeout (sec): %d, send/receive buffer size (bytes): %d (%s)]";
        String def = "use Netty's default";
        String man = "manual";
        return String.format(format, this.serverAddress, this.serverPortRange, this.getSSLEnabled() ? "true" : "false", this.memorySegmentSize, this.getServerNumThreads(), this.getServerNumThreads() == 0 ? def : man, this.getClientNumThreads(), this.getClientNumThreads() == 0 ? def : man, this.getServerConnectBacklog(), this.getServerConnectBacklog() == 0 ? def : man, this.getClientConnectTimeoutSeconds(), this.getSendAndReceiveBufferSize(), this.getSendAndReceiveBufferSize() == 0 ? def : man);
    }

    static enum TransportType {
        NIO,
        EPOLL,
        AUTO;

    }
}

