/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.metrics;

import org.apache.flink.runtime.io.network.metrics.AbstractBuffersUsageGauge;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;

public class ExclusiveBuffersUsageGauge
extends AbstractBuffersUsageGauge {
    public ExclusiveBuffersUsageGauge(SingleInputGate[] inputGates) {
        super(Preconditions.checkNotNull(inputGates));
    }

    @Override
    public int calculateUsedBuffers(SingleInputGate inputGate) {
        int usedBuffers = 0;
        for (InputChannel ic : inputGate.inputChannels()) {
            if (!(ic instanceof RemoteInputChannel)) continue;
            usedBuffers += ((RemoteInputChannel)ic).unsynchronizedGetExclusiveBuffersUsed();
        }
        return usedBuffers;
    }

    @Override
    public int calculateTotalBuffers(SingleInputGate inputGate) {
        int totalExclusiveBuffers = 0;
        for (InputChannel ic : inputGate.inputChannels()) {
            if (!(ic instanceof RemoteInputChannel)) continue;
            totalExclusiveBuffers += ((RemoteInputChannel)ic).getInitialCredit();
        }
        return totalExclusiveBuffers;
    }
}

