/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;

public class ErrorInfo
implements Serializable {
    private static final long serialVersionUID = -6138942031953594202L;
    private final SerializedThrowable exception;
    private final long timestamp;

    public static ErrorInfo createErrorInfoWithNullableCause(@Nullable Throwable exception, long timestamp) {
        return new ErrorInfo(ErrorInfo.handleMissingThrowable(exception), timestamp);
    }

    public static Throwable handleMissingThrowable(@Nullable Throwable throwable) {
        return throwable != null ? throwable : new FlinkException("Unknown cause for Execution failure (this might be caused by FLINK-21376).");
    }

    public ErrorInfo(@Nonnull Throwable exception, long timestamp) {
        Preconditions.checkNotNull(exception);
        Preconditions.checkArgument(timestamp > 0L);
        this.exception = exception instanceof SerializedThrowable ? (SerializedThrowable)exception : new SerializedThrowable(exception);
        this.timestamp = timestamp;
    }

    public SerializedThrowable getException() {
        return this.exception;
    }

    public String getExceptionAsString() {
        return this.exception.getFullStringifiedStackTrace();
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

