/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobInputStream;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobOutputStream;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlobClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BlobClient.class);
    private final Socket socket;

    public BlobClient(InetSocketAddress serverAddress, Configuration clientConfig) throws IOException {
        Socket socket = null;
        try {
            if (SecurityOptions.isInternalSSLEnabled(clientConfig) && clientConfig.get(BlobServerOptions.SSL_ENABLED).booleanValue()) {
                LOG.info("Using ssl connection to the blob server");
                socket = SSLUtils.createSSLClientSocketFactory(clientConfig).createSocket();
            } else {
                socket = new Socket();
            }
            socket.connect(new InetSocketAddress(serverAddress.getHostName(), serverAddress.getPort()), clientConfig.get(BlobServerOptions.CONNECT_TIMEOUT));
            socket.setSoTimeout(clientConfig.get(BlobServerOptions.SO_TIMEOUT));
        }
        catch (Exception e) {
            BlobUtils.closeSilently(socket, LOG);
            throw new IOException("Could not connect to BlobServer at address " + String.valueOf(serverAddress), e);
        }
        this.socket = socket;
    }

    /*
     * Exception decompiling
     */
    static void downloadFromBlobServer(@Nullable JobID jobId, BlobKey blobKey, File localJarFile, InetSocketAddress serverAddress, Configuration blobClientConfig, int numFetchRetries) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    InputStream getInternal(@Nullable JobID jobId, BlobKey blobKey) throws IOException {
        if (this.socket.isClosed()) {
            throw new IllegalStateException("BLOB Client is not connected. Client has been shut down or encountered an error before.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("GET BLOB {}/{} from {}.", new Object[]{jobId, blobKey, this.socket.getLocalSocketAddress()});
        }
        try {
            OutputStream os = this.socket.getOutputStream();
            InputStream is = this.socket.getInputStream();
            BlobClient.sendGetHeader(os, jobId, blobKey);
            BlobClient.receiveAndCheckGetResponse(is);
            return new BlobInputStream(is, blobKey, os);
        }
        catch (Throwable t) {
            BlobUtils.closeSilently(this.socket, LOG);
            throw new IOException("GET operation failed: " + t.getMessage(), t);
        }
    }

    private static void sendGetHeader(OutputStream outputStream, @Nullable JobID jobId, BlobKey blobKey) throws IOException {
        Preconditions.checkNotNull(blobKey);
        Preconditions.checkArgument(jobId != null || blobKey instanceof TransientBlobKey, "permanent BLOBs must be job-related");
        outputStream.write(1);
        if (jobId == null) {
            outputStream.write(0);
        } else {
            outputStream.write(2);
            outputStream.write(jobId.getBytes());
        }
        blobKey.writeToOutputStream(outputStream);
    }

    private static void receiveAndCheckGetResponse(InputStream is) throws IOException {
        int response = is.read();
        if (response < 0) {
            throw new EOFException("Premature end of response");
        }
        if (response == 1) {
            Throwable cause = BlobUtils.readExceptionFromStream(is);
            throw new IOException("Server side error: " + cause.getMessage(), cause);
        }
        if (response != 0) {
            throw new IOException("Unrecognized response");
        }
    }

    BlobKey putBuffer(@Nullable JobID jobId, byte[] value, int offset, int len, BlobKey.BlobType blobType) throws IOException {
        BlobKey blobKey;
        if (this.socket.isClosed()) {
            throw new IllegalStateException("BLOB Client is not connected. Client has been shut down or encountered an error before.");
        }
        Preconditions.checkNotNull(value);
        if (LOG.isDebugEnabled()) {
            LOG.debug("PUT BLOB buffer (" + len + " bytes) to " + String.valueOf(this.socket.getLocalSocketAddress()) + ".");
        }
        BlobOutputStream os = new BlobOutputStream(jobId, blobType, this.socket);
        try {
            os.write(value, offset, len);
            blobKey = os.finish();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                BlobUtils.closeSilently(this.socket, LOG);
                throw new IOException("PUT operation failed: " + t.getMessage(), t);
            }
        }
        os.close();
        return blobKey;
    }

    BlobKey putInputStream(@Nullable JobID jobId, InputStream inputStream, BlobKey.BlobType blobType) throws IOException {
        BlobKey blobKey;
        if (this.socket.isClosed()) {
            throw new IllegalStateException("BLOB Client is not connected. Client has been shut down or encountered an error before.");
        }
        Preconditions.checkNotNull(inputStream);
        if (LOG.isDebugEnabled()) {
            LOG.debug("PUT BLOB stream to {}.", (Object)this.socket.getLocalSocketAddress());
        }
        BlobOutputStream os = new BlobOutputStream(jobId, blobType, this.socket);
        try {
            IOUtils.copyBytes(inputStream, os, 65536, false);
            blobKey = os.finish();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                BlobUtils.closeSilently(this.socket, LOG);
                throw new IOException("PUT operation failed: " + t.getMessage(), t);
            }
        }
        os.close();
        return blobKey;
    }

    public static List<PermanentBlobKey> uploadFiles(InetSocketAddress serverAddress, Configuration clientConfig, JobID jobId, List<Path> files) throws IOException {
        Preconditions.checkNotNull(jobId);
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PermanentBlobKey> blobKeys = new ArrayList<PermanentBlobKey>();
        try (BlobClient blobClient = new BlobClient(serverAddress, clientConfig);){
            for (Path file : files) {
                PermanentBlobKey key = blobClient.uploadFile(jobId, file);
                blobKeys.add(key);
            }
        }
        return blobKeys;
    }

    public PermanentBlobKey uploadFile(JobID jobId, Path file) throws IOException {
        FileSystem fs = file.getFileSystem();
        try (FSDataInputStream is = fs.open(file);){
            PermanentBlobKey permanentBlobKey = (PermanentBlobKey)this.putInputStream(jobId, is, BlobKey.BlobType.PERMANENT_BLOB);
            return permanentBlobKey;
        }
    }
}

