/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;

@Internal
public class SimpleVersionedSerializerAdapter<T>
implements SimpleVersionedSerializer<T>,
Serializable {
    private final TypeSerializer<T> serializer;

    public SimpleVersionedSerializerAdapter(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public int getVersion() {
        return this.serializer.snapshotConfiguration().getCurrentVersion();
    }

    @Override
    public byte[] serialize(T value) throws IOException {
        DataOutputSerializer dataOutputSerializer = new DataOutputSerializer(10);
        this.serializer.serialize(value, dataOutputSerializer);
        return dataOutputSerializer.getCopyOfBuffer();
    }

    @Override
    public T deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer dataInputDeserializer = new DataInputDeserializer(serialized);
        T value = this.serializer.deserialize(dataInputDeserializer);
        dataInputDeserializer.releaseArrays();
        return value;
    }
}

