/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class TupleSerializerBase<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    protected final Class<T> tupleClass;
    protected TypeSerializer<Object>[] fieldSerializers;
    protected final int arity;
    private int length = -2;

    public TupleSerializerBase(Class<T> tupleClass, TypeSerializer<?>[] fieldSerializers) {
        this.tupleClass = Preconditions.checkNotNull(tupleClass);
        this.fieldSerializers = Preconditions.checkNotNull(fieldSerializers);
        this.arity = fieldSerializers.length;
    }

    public Class<T> getTupleClass() {
        return this.tupleClass;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public int getLength() {
        if (this.length == -2) {
            int sum = 0;
            for (TypeSerializer<Object> serializer : this.fieldSerializers) {
                if (serializer.getLength() > 0) {
                    sum += serializer.getLength();
                    continue;
                }
                this.length = -1;
                return this.length;
            }
            this.length = sum;
        }
        return this.length;
    }

    public int getArity() {
        return this.arity;
    }

    public abstract T createInstance(Object[] var1);

    public abstract T createOrReuseInstance(Object[] var1, T var2);

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        for (int i = 0; i < this.arity; ++i) {
            this.fieldSerializers[i].copy(source, target);
        }
    }

    @Override
    public int hashCode() {
        return 31 * Arrays.hashCode(this.fieldSerializers) + Objects.hash(this.tupleClass, this.arity);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TupleSerializerBase) {
            TupleSerializerBase other = (TupleSerializerBase)obj;
            return this.tupleClass == other.tupleClass && Arrays.equals(this.fieldSerializers, other.fieldSerializers) && this.arity == other.arity;
        }
        return false;
    }

    public TypeSerializer<Object>[] getFieldSerializers() {
        return this.fieldSerializers;
    }
}

