/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.SetSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class SetTypeInfo<T>
extends TypeInformation<Set<T>> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation<T> elementTypeInfo;

    public SetTypeInfo(Class<T> elementTypeClass) {
        this.elementTypeInfo = SetTypeInfo.of(Preconditions.checkNotNull(elementTypeClass, "The element type class cannot be null."));
    }

    public SetTypeInfo(TypeInformation<T> elementTypeInfo) {
        this.elementTypeInfo = Preconditions.checkNotNull(elementTypeInfo, "The element type information cannot be null.");
    }

    public TypeInformation<T> getElementTypeInfo() {
        return this.elementTypeInfo;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<Set<T>> getTypeClass() {
        return Set.class;
    }

    @Override
    public boolean isKeyType() {
        return false;
    }

    @Override
    public TypeSerializer<Set<T>> createSerializer(SerializerConfig config) {
        TypeSerializer<T> elementTypeSerializer = this.elementTypeInfo.createSerializer(config);
        return new SetSerializer<T>(elementTypeSerializer);
    }

    @Override
    public String toString() {
        return "Set<" + String.valueOf(this.elementTypeInfo) + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SetTypeInfo) {
            SetTypeInfo other = (SetTypeInfo)obj;
            return other.canEqual(this) && this.elementTypeInfo.equals(other.elementTypeInfo);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.elementTypeInfo.hashCode() + 1;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

