/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.variant.BinaryVariant;
import org.apache.flink.types.variant.Variant;

@Internal
public class VariantSerializer
extends TypeSerializerSingleton<Variant> {
    public static final VariantSerializer INSTANCE = new VariantSerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public Variant createInstance() {
        return Variant.newBuilder().ofNull();
    }

    @Override
    public Variant copy(Variant from) {
        BinaryVariant binaryVariant = this.toBinaryVariant(from);
        return new BinaryVariant(Arrays.copyOf(binaryVariant.getValue(), binaryVariant.getValue().length), Arrays.copyOf(binaryVariant.getMetadata(), binaryVariant.getMetadata().length));
    }

    @Override
    public Variant copy(Variant from, Variant reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(Variant record, DataOutputView target) throws IOException {
        BinaryVariant binaryVariant = this.toBinaryVariant(record);
        target.writeInt(binaryVariant.getValue().length);
        target.writeInt(binaryVariant.getMetadata().length);
        target.write(binaryVariant.getValue());
        target.write(binaryVariant.getMetadata());
    }

    @Override
    public Variant deserialize(DataInputView source) throws IOException {
        int valueLength = source.readInt();
        int metadataLength = source.readInt();
        byte[] value = new byte[valueLength];
        byte[] metaData = new byte[metadataLength];
        source.read(value);
        source.read(metaData);
        return new BinaryVariant(value, metaData);
    }

    @Override
    public Variant deserialize(Variant reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int valueLength = source.readInt();
        int metadataLength = source.readInt();
        target.writeInt(valueLength);
        target.writeInt(metadataLength);
        target.write(source, valueLength + metadataLength);
    }

    @Override
    public TypeSerializerSnapshot<Variant> snapshotConfiguration() {
        return new VariantSerializerSnapshot();
    }

    private BinaryVariant toBinaryVariant(Variant variant) {
        if (variant instanceof BinaryVariant) {
            return (BinaryVariant)variant;
        }
        throw new UnsupportedOperationException("Unsupported variant type: " + String.valueOf(variant.getClass()));
    }

    @Internal
    public static final class VariantSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Variant> {
        public VariantSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

